

<?php $__env->startSection('content'); ?>
<div class="panel-card">
    <div class="panel-header">
        <h2>Orders</h2>
        <form method="GET" action="<?php echo e(route('admin.orders')); ?>" class="search-form">
            <select name="status">
                <option value="">All Status</option>
                <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="processing" <?php echo e(request('status') === 'processing' ? 'selected' : ''); ?>>Processing</option>
                <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
                <option value="cancelled" <?php echo e(request('status') === 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
            </select>
            <button type="submit">Filter</button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User ID</th>
                    <th>Bot</th>
                    <th>Trading Pair</th>
                    <th>Side</th>
                    <th>Amount</th>
                    <th>Profit/Loss</th>
                    <th>Status</th>
                    <th>Executed At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($order->id); ?></td>
                    <td><?php echo e(str_pad($order->user->id, 6, '0', STR_PAD_LEFT)); ?></td>
                    <td><?php echo e($order->aiTradeBot->name ?? 'N/A'); ?></td>
                    <td><?php echo e($order->trading_pair); ?></td>
                    <td>
                        <span style="color: <?php echo e($order->side === 'buy' ? '#26a69a' : '#ef5350'); ?>;">
                            <?php echo e(strtoupper($order->side)); ?>

                        </span>
                    </td>
                    <td>$<?php echo e(number_format($order->amount, 2)); ?></td>
                    <td style="color: <?php echo e(($order->admin_adjusted_profit_loss ?? $order->profit_loss) >= 0 ? '#26a69a' : '#ef5350'); ?>;">
                        $<?php echo e(number_format($order->admin_adjusted_profit_loss ?? $order->profit_loss, 2)); ?>

                        <?php if($order->admin_adjusted_profit_loss !== null): ?>
                            <small style="display: block; color: #8B8FA3; font-size: 11px;">(Adjusted)</small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <span class="badge badge-<?php echo e($order->status === 'filled' ? 'success' : ($order->status === 'cancelled' || $order->status === 'failed' ? 'danger' : 'warning')); ?>">
                            <?php echo e(ucfirst($order->status)); ?>

                        </span>
                    </td>
                    <td><?php echo e($order->executed_at ? $order->executed_at->format('Y-m-d H:i') : 'N/A'); ?></td>
                    <td>
                        <a href="<?php echo e(route('admin.orders.show', $order->id)); ?>" class="btn btn-sm btn-primary">View</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="10" class="text-center">No orders found</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo $__env->make('admin.partials.pagination', ['items' => $orders], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/orders/index.blade.php ENDPATH**/ ?>