

<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
<div class="alert alert-success" style="background: var(--primary-soft); color: var(--primary); padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid var(--primary);">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<div class="panel-card">
    <div class="panel-header">
        <h2><?php echo e(__('admin.users.title')); ?></h2>
        <form method="GET" action="<?php echo e(route('admin.users')); ?>" class="search-form">
            <input type="text" name="search" placeholder="<?php echo e(__('admin.users.search_placeholder')); ?>" value="<?php echo e(request('search')); ?>">
            <select name="status">
                <option value=""><?php echo e(__('admin.users.all_status')); ?></option>
                <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>><?php echo e(__('admin.users.active')); ?></option>
                <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>><?php echo e(__('admin.users.inactive')); ?></option>
            </select>
            <button type="submit"><?php echo e(__('admin.users.search')); ?></button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                    <tr>
                        <th><?php echo e(__('admin.table.id')); ?></th>
                        <th><?php echo e(__('admin.users.wallet_address')); ?></th>
                        <th><?php echo e(__('admin.users.name')); ?></th>
                        <th><?php echo e(__('admin.users.score')); ?></th>
                        <th><?php echo e(__('admin.users.balance')); ?></th>
                        <th><?php echo e(__('admin.users.status')); ?></th>
                        <th><?php echo e(__('admin.users.verified')); ?></th>
                        <th><?php echo e(__('admin.table.actions')); ?></th>
                    </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e(str_pad($user->id, 6, '0', STR_PAD_LEFT)); ?></td>
                    <td><?php echo e(substr($user->wallet_address, 0, 10)); ?>...</td>
                    <td><?php echo e($user->name); ?></td>
                    <td>
                        <span style="display: flex; align-items: center; gap: 4px;">
                            <span>⭐</span>
                            <span><?php echo e(number_format($user->account_weight_score, 2)); ?></span>
                        </span>
                    </td>
                    <td title="Total Portfolio (USD) – matches Assets page">$<?php echo e(number_format($totalPortfolioByUser[$user->id] ?? 0, 2)); ?></td>
                    <td>
                        <span class="badge <?php echo e($user->is_active ? 'badge-success' : 'badge-danger'); ?>">
                            <?php echo e($user->is_active ? __('admin.users.active') : __('admin.users.inactive')); ?>

                        </span>
                    </td>
                    <td>
                        <span class="badge <?php echo e($user->is_verified ? 'badge-success' : 'badge-warning'); ?>">
                            <?php echo e($user->is_verified ? __('admin.users.verified') : __('admin.users.pending')); ?>

                        </span>
                    </td>
                    <td>
                        <div style="display: flex; gap: 6px; flex-wrap: wrap;">
                            <a href="<?php echo e(route('admin.users.show', $user->id)); ?>" class="btn btn-sm btn-primary"><?php echo e(__('admin.users.view')); ?></a>
                            <?php if(!$user->is_verified): ?>
                            <button type="button" class="btn btn-sm btn-success" title="<?php echo e(__('admin.users.verify_user')); ?>" onclick="showVerifyModal(<?php echo e($user->id); ?>, '<?php echo e($user->name); ?>')">✓ <?php echo e(__('admin.users.verify_user')); ?></button>
                            <?php endif; ?>
                            <button type="button" class="btn btn-sm btn-warning" title="<?php echo e(__('admin.users.set_reset_pin')); ?>" onclick="showPinModal(<?php echo e($user->id); ?>, '<?php echo e(addslashes($user->name)); ?>', <?php echo e($user->withdrawal_pin_hash ? 'true' : 'false'); ?>)"><?php echo e(__('admin.users.set_reset_pin')); ?></button>
                            <button type="button" class="btn btn-sm btn-danger" title="<?php echo e(__('admin.users.delete_user')); ?>" onclick="showDeleteModal(<?php echo e($user->id); ?>, <?php echo e(json_encode($user->name)); ?>)"><?php echo e(__('admin.common.delete')); ?></button>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" class="text-center"><?php echo e(__('admin.users.no_found')); ?></td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo $__env->make('admin.partials.pagination', ['items' => $users], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<!-- Delete User Confirmation Modal (custom toast-style confirm) -->
<div id="deleteUserModal" class="modal-backdrop" style="display: none;">
    <div class="modal-card">
        <div class="modal-header">
            <h3 class="modal-title"><?php echo e(__('admin.users.delete_user_modal_title')); ?></h3>
        </div>
        <div class="modal-body">
            <p style="color: var(--text); margin: 0;"><?php echo e(__('admin.users.delete_user_confirm_text')); ?> <strong id="deleteUserName"></strong>? <?php echo e(__('admin.users.delete_user_cannot_undo')); ?></p>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-outline" onclick="closeDeleteModal()"><?php echo e(__('admin.common.cancel')); ?></button>
            <form id="deleteUserForm" method="POST" action="#" style="display: inline;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger"><?php echo e(__('admin.users.confirm_delete')); ?></button>
            </form>
        </div>
    </div>
</div>

<!-- Verify Confirmation Modal -->
<div id="verifyModal" class="modal-backdrop" style="display: none;">
    <div class="modal-card">
        <div class="modal-header">
            <h3 class="modal-title"><?php echo e(__('admin.users.verify_modal_title')); ?></h3>
        </div>
        <div class="modal-body">
            <p style="color: var(--text); margin: 0;"><?php echo e(__('admin.users.verify_confirm_text')); ?> <strong id="verifyUserName"></strong>?</p>
            <p style="color: var(--muted); margin: 8px 0 0 0; font-size: 14px;"><?php echo e(__('admin.users.verify_kyc_note')); ?></p>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-outline" onclick="closeVerifyModal()"><?php echo e(__('admin.common.cancel')); ?></button>
            <form id="verifyForm" method="POST" style="display: inline;">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-success"><?php echo e(__('admin.users.confirm_verify')); ?></button>
            </form>
        </div>
    </div>
</div>

<script>
let currentVerifyUserId = null;

function showDeleteModal(userId, userName) {
    document.getElementById('deleteUserName').textContent = userName;
    document.getElementById('deleteUserForm').action = '<?php echo e(route('admin.users.destroy', ':id')); ?>'.replace(':id', userId);
    document.getElementById('deleteUserModal').style.display = 'flex';
}

function closeDeleteModal() {
    document.getElementById('deleteUserModal').style.display = 'none';
}

document.getElementById('deleteUserModal').addEventListener('click', function(e) {
    if (e.target === this) closeDeleteModal();
});
document.getElementById('deleteUserModal').addEventListener('keydown', function(e) {
    if (e.key === 'Escape') closeDeleteModal();
});

function showVerifyModal(userId, userName) {
    currentVerifyUserId = userId;
    document.getElementById('verifyUserName').textContent = userName;
    document.getElementById('verifyForm').action = '<?php echo e(route('admin.users.verify', ':id')); ?>'.replace(':id', userId);
    document.getElementById('verifyModal').style.display = 'flex';
}

function closeVerifyModal() {
    document.getElementById('verifyModal').style.display = 'none';
    currentVerifyUserId = null;
}

// Close modal on backdrop click
document.getElementById('verifyModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeVerifyModal();
    }
});

// Close modal on ESC key
document.getElementById('verifyModal').addEventListener('keydown', function(e) {
    if (e.key === 'Escape') closeVerifyModal();
});

// --- Set/Reset PIN Modal (in-app, no browser confirm) ---
let currentPinUserId = null;
let currentPinUserHasPin = false;

function showPinModal(userId, userName, userHasPin) {
    currentPinUserId = userId;
    currentPinUserHasPin = userHasPin;
    document.getElementById('pinModalUserName').textContent = userName;
    document.getElementById('pinNewPin').value = '';
    document.getElementById('pinConfirm').value = '';
    document.getElementById('pinError').textContent = '';
    document.getElementById('pinError').style.display = 'none';
    document.getElementById('pinClearBtn').style.display = userHasPin ? 'inline-block' : 'none';
    document.getElementById('pinModal').style.display = 'flex';
}

function closePinModal() {
    document.getElementById('pinModal').style.display = 'none';
    currentPinUserId = null;
}

function submitSetPin() {
    const newPin = (document.getElementById('pinNewPin').value || '').replace(/\D/g, '');
    const confirmPin = (document.getElementById('pinConfirm').value || '').replace(/\D/g, '');
    const errEl = document.getElementById('pinError');
    if (newPin.length !== 6) {
        errEl.textContent = <?php echo json_encode(__('admin.users.pin_must_6'), 15, 512) ?>;
        errEl.style.display = 'block';
        return;
    }
    if (newPin !== confirmPin) {
        errEl.textContent = <?php echo json_encode(__('admin.users.pin_no_match'), 15, 512) ?>;
        errEl.style.display = 'block';
        return;
    }
    errEl.style.display = 'none';
    const form = document.getElementById('pinSetForm');
    form.action = '<?php echo e(route('admin.users.set-pin', ':id')); ?>'.replace(':id', currentPinUserId);
    form.pin.value = newPin;
    form.pin_confirmation.value = confirmPin;
    form.submit();
}

function submitClearPin() {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '<?php echo e(route('admin.users.reset-pin', ':id')); ?>'.replace(':id', currentPinUserId);
    const csrf = document.createElement('input');
    csrf.type = 'hidden';
    csrf.name = '_token';
    csrf.value = '<?php echo e(csrf_token()); ?>';
    form.appendChild(csrf);
    document.body.appendChild(form);
    form.submit();
}
</script>

<!-- Set/Reset PIN Modal -->
<div id="pinModal" class="modal-backdrop" style="display: none;">
    <div class="modal-card">
        <div class="modal-header">
            <h3 class="modal-title"><?php echo e(__('admin.users.pin_modal_title')); ?></h3>
        </div>
        <div class="modal-body">
            <p style="color: var(--text); margin: 0 0 16px 0;"><?php echo e(__('admin.users.pin_modal_user')); ?> <strong id="pinModalUserName"></strong></p>
            <p style="color: var(--muted); font-size: 14px; margin-bottom: 16px;"><?php echo e(__('admin.users.pin_modal_note')); ?></p>
            <form id="pinSetForm" method="POST" action="#" style="display: block;">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="pin" id="pinSetFormPin" value="">
                <input type="hidden" name="pin_confirmation" id="pinSetFormConfirm" value="">
                <div class="form-group" style="margin-bottom: 12px;">
                    <label style="display: block; margin-bottom: 4px; color: var(--text);"><?php echo e(__('admin.users.new_pin')); ?></label>
                    <input type="password" id="pinNewPin" inputmode="numeric" maxlength="6" placeholder="••••••" class="form-control" style="width: 100%; padding: 8px 12px; border-radius: 8px; border: 1px solid var(--border); background: var(--bg); color: var(--text);">
                </div>
                <div class="form-group" style="margin-bottom: 12px;">
                    <label style="display: block; margin-bottom: 4px; color: var(--text);"><?php echo e(__('admin.users.confirm_new_pin')); ?></label>
                    <input type="password" id="pinConfirm" inputmode="numeric" maxlength="6" placeholder="••••••" class="form-control" style="width: 100%; padding: 8px 12px; border-radius: 8px; border: 1px solid var(--border); background: var(--bg); color: var(--text);">
                </div>
                <div id="pinError" style="display: none; color: #dc3545; font-size: 14px; margin-bottom: 12px;"></div>
            </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-outline" onclick="closePinModal()"><?php echo e(__('admin.common.cancel')); ?></button>
            <button type="button" id="pinClearBtn" class="btn btn-outline" style="display: none;" onclick="submitClearPin()"><?php echo e(__('admin.users.clear_pin')); ?></button>
            <button type="button" class="btn btn-warning" onclick="submitSetPin()"><?php echo e(__('admin.users.set_pin_btn')); ?></button>
        </div>
    </div>
</div>

<script>
document.getElementById('pinModal').addEventListener('click', function(e) {
    if (e.target === this) closePinModal();
});
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape' && document.getElementById('pinModal').style.display === 'flex') closePinModal();
});
// Form submit: set hidden fields from visible inputs before submit
document.getElementById('pinSetForm').addEventListener('submit', function() {
    this.querySelector('input[name="pin"]').value = (document.getElementById('pinNewPin').value || '').replace(/\D/g, '');
    this.querySelector('input[name="pin_confirmation"]').value = (document.getElementById('pinConfirm').value || '').replace(/\D/g, '');
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/users/index.blade.php ENDPATH**/ ?>