

<?php $__env->startSection('content'); ?>
<div class="panel-card">
    <div class="panel-header">
        <h2><?php echo e(__('admin.ai_trade.bots_title')); ?></h2>
        <form method="GET" action="<?php echo e(route('admin.ai-trade')); ?>" class="search-form">
            <select name="status">
                <option value=""><?php echo e(__('admin.users.all_status')); ?></option>
                <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>><?php echo e(__('admin.ai_trade.active')); ?></option>
                <option value="paused" <?php echo e(request('status') === 'paused' ? 'selected' : ''); ?>><?php echo e(__('admin.ai_trade.paused')); ?></option>
                <option value="stopped" <?php echo e(request('status') === 'stopped' ? 'selected' : ''); ?>><?php echo e(__('admin.ai_trade.stopped')); ?></option>
                <option value="closed" <?php echo e(request('status') === 'closed' ? 'selected' : ''); ?>><?php echo e(__('admin.ai_trade.closed')); ?></option>
            </select>
            <button type="submit"><?php echo e(__('admin.deposits.filter')); ?></button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th><?php echo e(__('admin.table.id')); ?></th>
                    <th><?php echo e(__('admin.ai_trade.user_id')); ?></th>
                    <th><?php echo e(__('admin.ai_trade.name')); ?></th>
                    <th><?php echo e(__('admin.ai_trade.trading_pair')); ?></th>
                    <th><?php echo e(__('admin.ai_trade.amount')); ?></th>
                    <th><?php echo e(__('admin.ai_trade.total_profit')); ?></th>
                    <th><?php echo e(__('admin.ai_trade.total_loss')); ?></th>
                    <th><?php echo e(__('admin.ai_trade.net_pl')); ?></th>
                    <th><?php echo e(__('admin.ai_trade.status')); ?></th>
                    <th><?php echo e(__('admin.table.actions')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $bots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($bot->id); ?></td>
                    <td><?php echo e(str_pad($bot->user->id, 6, '0', STR_PAD_LEFT)); ?></td>
                    <td><?php echo e($bot->name); ?></td>
                    <td><?php echo e($bot->trading_pair); ?></td>
                    <td>$<?php echo e(number_format($bot->amount, 2)); ?></td>
                    <?php
                        $profit = $bot->live_pl ? $bot->live_pl['totalProfit'] : (float)$bot->total_profit;
                        $loss = $bot->live_pl ? $bot->live_pl['totalLoss'] : (float)$bot->total_loss;
                        $net = $profit - $loss;
                    ?>
                    <td style="color: #26a69a;">$<?php echo e(number_format($profit, 2)); ?><?php echo e($bot->live_pl ? ' <small style="opacity:0.8">(live)</small>' : ''); ?></td>
                    <td style="color: #ef5350;">$<?php echo e(number_format($loss, 2)); ?></td>
                    <td style="color: <?php echo e($net >= 0 ? '#26a69a' : '#ef5350'); ?>;">
                        $<?php echo e(number_format($net, 2)); ?>

                    </td>
                    <td>
                        <span class="badge badge-<?php echo e($bot->status === 'active' ? 'success' : ($bot->status === 'stopped' ? 'danger' : ($bot->status === 'closed' ? 'secondary' : 'warning'))); ?>">
                            <?php echo e(__('admin.ai_trade.' . $bot->status)); ?>

                        </span>
                        <?php if($bot->status === 'active' && $bot->admin_activated_at): ?>
                        <div style="font-size: 11px; color: #22c55e; margin-top: 4px;">Started: <?php echo e($bot->admin_activated_at->format('M d, H:i')); ?></div>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo e(route('admin.ai-trade.show', $bot->id)); ?>" class="btn btn-sm btn-primary"><?php echo e(__('admin.ai_trade.view')); ?></a>
                        <?php if($bot->status !== 'closed'): ?>
                        <form id="close-bot-form-<?php echo e($bot->id); ?>" method="POST" action="<?php echo e(route('admin.ai-trade.close', $bot->id)); ?>" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="button" class="btn btn-sm btn-secondary btn-close-bot" data-form-id="close-bot-form-<?php echo e($bot->id); ?>"><?php echo e(__('admin.ai_trade.close_bot')); ?></button>
                        </form>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="10" class="text-center"><?php echo e(__('admin.ai_trade.no_found')); ?></td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo $__env->make('admin.partials.pagination', ['items' => $bots], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>


<div id="closeBotModal" class="admin-modal" style="display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 9999; align-items: center; justify-content: center;">
    <div class="admin-modal-content" style="background: var(--card-bg, #1e293b); border-radius: 12px; padding: 24px; max-width: 400px; box-shadow: 0 20px 40px rgba(0,0,0,0.3); border: 1px solid var(--border-color, #334155);">
        <h3 style="margin: 0 0 12px 0; font-size: 18px; color: var(--text, #f1f5f9);"><?php echo e(__('admin.ai_trade.close_bot')); ?>?</h3>
        <p style="margin: 0 0 20px 0; color: var(--muted, #94a3b8); font-size: 14px;"><?php echo e(__('admin.ai_trade.close_confirm')); ?></p>
        <div style="display: flex; gap: 12px; justify-content: flex-end;">
            <button type="button" id="closeBotModalCancel" class="btn btn-outline" style="padding: 8px 16px;"><?php echo e(__('admin.common.cancel')); ?></button>
            <button type="button" id="closeBotModalConfirm" class="btn btn-primary" style="padding: 8px 16px;"><?php echo e(__('admin.deposits.confirm')); ?></button>
        </div>
    </div>
</div>

<script>
(function() {
    var modal = document.getElementById('closeBotModal');
    var formToSubmit = null;
    document.querySelectorAll('.btn-close-bot').forEach(function(btn) {
        btn.addEventListener('click', function() {
            formToSubmit = document.getElementById(this.getAttribute('data-form-id'));
            if (modal) modal.style.display = 'flex';
        });
    });
    if (modal) {
        document.getElementById('closeBotModalCancel').onclick = function() {
            modal.style.display = 'none';
            formToSubmit = null;
        };
        document.getElementById('closeBotModalConfirm').onclick = function() {
            if (formToSubmit) formToSubmit.submit();
            modal.style.display = 'none';
            formToSubmit = null;
        };
        modal.addEventListener('click', function(e) {
            if (e.target === modal) { modal.style.display = 'none'; formToSubmit = null; }
        });
    }
})();
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/ai-trade/index.blade.php ENDPATH**/ ?>