<?php if(isset($items)): ?>
<?php
    $hasPages = method_exists($items, 'hasPages') ? $items->hasPages() : false;
    $total = method_exists($items, 'total') ? $items->total() : 0;
    $currentPage = method_exists($items, 'currentPage') ? $items->currentPage() : 1;
    $lastPage = method_exists($items, 'lastPage') ? $items->lastPage() : 1;
    $onFirstPage = method_exists($items, 'onFirstPage') ? $items->onFirstPage() : true;
    $hasMorePages = method_exists($items, 'hasMorePages') ? $items->hasMorePages() : false;
?>
<?php if($hasPages || $total > 0): ?>
<div class="admin-pagination">
    <div class="pagination-info">
        <span class="pagination-total"><?php echo e(__('admin.pagination.total')); ?> <?php echo e($total); ?></span>
        
        <select class="pagination-per-page" onchange="changePerPage(this.value)">
            <option value="10" <?php echo e(request('per_page', 10) == 10 ? 'selected' : ''); ?>><?php echo e(__('admin.pagination.per_page', ['count' => 10])); ?></option>
            <option value="20" <?php echo e(request('per_page', 10) == 20 ? 'selected' : ''); ?>><?php echo e(__('admin.pagination.per_page', ['count' => 20])); ?></option>
            <option value="50" <?php echo e(request('per_page', 10) == 50 ? 'selected' : ''); ?>><?php echo e(__('admin.pagination.per_page', ['count' => 50])); ?></option>
            <option value="100" <?php echo e(request('per_page', 10) == 100 ? 'selected' : ''); ?>><?php echo e(__('admin.pagination.per_page', ['count' => 100])); ?></option>
        </select>
    </div>

    <div class="pagination-controls">
        <!-- Previous Button -->
        <button 
            class="pagination-btn <?php echo e($onFirstPage ? 'disabled' : ''); ?>"
            onclick="goToPage(<?php echo e($currentPage - 1); ?>)"
            <?php echo e($onFirstPage ? 'disabled' : ''); ?>

        >
            ‹
        </button>

        <!-- Page Numbers -->
        <?php
            $startPage = max(1, $currentPage - 2);
            $endPage = min($lastPage, $currentPage + 2);
            
            // Show first page if not in range
            if ($startPage > 1) {
                $showFirst = true;
            } else {
                $showFirst = false;
            }
            
            // Show last page if not in range
            if ($endPage < $lastPage) {
                $showLast = true;
            } else {
                $showLast = false;
            }
        ?>

        <?php if($showFirst): ?>
            <button class="pagination-btn" onclick="goToPage(1)">1</button>
            <?php if($startPage > 2): ?>
                <span class="pagination-ellipsis">...</span>
            <?php endif; ?>
        <?php endif; ?>

        <?php for($page = $startPage; $page <= $endPage; $page++): ?>
            <button 
                class="pagination-btn <?php echo e($page == $currentPage ? 'active' : ''); ?>"
                onclick="goToPage(<?php echo e($page); ?>)"
            >
                <?php echo e($page); ?>

            </button>
        <?php endfor; ?>

        <?php if($showLast): ?>
            <?php if($endPage < $lastPage - 1): ?>
                <span class="pagination-ellipsis">...</span>
            <?php endif; ?>
            <button class="pagination-btn" onclick="goToPage(<?php echo e($lastPage); ?>)"><?php echo e($lastPage); ?></button>
        <?php endif; ?>

        <!-- Next Button -->
        <button 
            class="pagination-btn <?php echo e($hasMorePages ? '' : 'disabled'); ?>"
            onclick="goToPage(<?php echo e($currentPage + 1); ?>)"
            <?php echo e($hasMorePages ? '' : 'disabled'); ?>

        >
            ›
        </button>
    </div>

    <div class="pagination-goto">
        <span><?php echo e(__('admin.pagination.go_to')); ?></span>
        <input 
            type="number" 
            class="pagination-goto-input" 
            min="1" 
            max="<?php echo e($lastPage); ?>" 
            value="<?php echo e($currentPage); ?>"
            onkeypress="if(event.key === 'Enter') { goToPage(this.value); }"
        >
    </div>
</div>

<script>
function goToPage(page) {
    if (page < 1 || page > <?php echo e($lastPage); ?>) return;
    
    const url = new URL(window.location.href);
    url.searchParams.set('page', page);
    
    // Preserve other query parameters
    <?php $__currentLoopData = request()->except('page', 'per_page'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        url.searchParams.set('<?php echo e($key); ?>', '<?php echo e($value); ?>');
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    // Preserve per_page if set
    const perPage = url.searchParams.get('per_page') || '<?php echo e(request('per_page', 10)); ?>';
    if (perPage) {
        url.searchParams.set('per_page', perPage);
    }
    
    window.location.href = url.toString();
}

function changePerPage(perPage) {
    const url = new URL(window.location.href);
    url.searchParams.set('per_page', perPage);
    url.searchParams.set('page', '1'); // Reset to first page
    
    // Preserve other query parameters
    <?php $__currentLoopData = request()->except('page', 'per_page'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        url.searchParams.set('<?php echo e($key); ?>', '<?php echo e($value); ?>');
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    window.location.href = url.toString();
}
</script>
<?php endif; ?>
<?php endif; ?>

<?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/partials/pagination.blade.php ENDPATH**/ ?>