

<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
<div class="alert alert-success" style="background: var(--primary-soft); color: var(--primary); padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid var(--primary);">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<?php if(session('error')): ?>
<div class="alert alert-error" style="background: rgba(239, 68, 68, 0.15); color: #ef4444; padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid rgba(239, 68, 68, 0.3);">
    <?php echo e(session('error')); ?>

</div>
<?php endif; ?>

<?php if($errors->any()): ?>
<div class="alert alert-error" style="background: rgba(239, 68, 68, 0.15); color: #ef4444; padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid rgba(239, 68, 68, 0.3);">
    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div><?php echo e($error); ?></div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php endif; ?>

<div class="panel-card">
    <div class="panel-header">
        <h2><?php echo e(__('admin.deposits.title')); ?></h2>
        <form method="GET" action="<?php echo e(route('admin.deposits')); ?>" class="search-form">
            <select name="status">
                <option value=""><?php echo e(__('admin.users.all_status')); ?></option>
                <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>><?php echo e(__('admin.deposits.pending')); ?></option>
                <option value="confirmed" <?php echo e(request('status') === 'confirmed' ? 'selected' : ''); ?>><?php echo e(__('admin.deposits.confirmed')); ?></option>
                <option value="rejected" <?php echo e(request('status') === 'rejected' ? 'selected' : ''); ?>><?php echo e(__('admin.deposits.rejected')); ?></option>
            </select>
            <button type="submit"><?php echo e(__('admin.deposits.filter')); ?></button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th><?php echo e(__('admin.table.id')); ?></th>
                    <th><?php echo e(__('admin.deposits.user')); ?></th>
                    <th><?php echo e(__('admin.deposits.network')); ?></th>
                    <th><?php echo e(__('admin.deposits.amount')); ?></th>
                    <th><?php echo e(__('admin.deposits.voucher')); ?></th>
                    <th><?php echo e(__('admin.deposits.status')); ?></th>
                    <th><?php echo e(__('admin.deposits.date')); ?></th>
                    <th><?php echo e(__('admin.table.actions')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e(str_pad($deposit->user_id ?? 0, 6, '0', STR_PAD_LEFT)); ?></td>
                    <td><?php echo e(substr($deposit->user->wallet_address ?? 'N/A', 0, 15)); ?>...</td>
                    <td><?php echo e($deposit->network); ?></td>
                    <td>$<?php echo e(number_format($deposit->amount, 2)); ?></td>
                    <td>
                        <?php if($deposit->voucher_path): ?>
                        <div style="display: flex; gap: 6px; align-items: center;">
                            <button type="button" class="btn btn-sm btn-info" onclick="viewVoucher('<?php echo e(asset('storage/' . $deposit->voucher_path)); ?>')"><?php echo e(__('admin.deposits.view')); ?></button>
                            <a href="<?php echo e(asset('storage/' . $deposit->voucher_path)); ?>" download class="btn btn-sm btn-outline-info"><?php echo e(__('admin.deposits.download')); ?></a>
                        </div>
                        <?php else: ?>
                        <span class="text-muted"><?php echo e(__('admin.deposits.no_voucher')); ?></span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <span class="badge badge-<?php echo e($deposit->status === 'confirmed' ? 'success' : ($deposit->status === 'rejected' ? 'danger' : 'warning')); ?>">
                            <?php echo e(__('admin.deposits.' . $deposit->status)); ?>

                        </span>
                    </td>
                    <td><?php echo e($deposit->created_at->format('Y-m-d H:i')); ?></td>
                    <td>
                        <?php if($deposit->status === 'pending'): ?>
                        <div style="display: flex; flex-direction: column; gap: 8px;">
                            <button type="button" class="btn btn-sm btn-success" onclick="showConfirmModal(<?php echo e($deposit->id); ?>, <?php echo e($deposit->amount); ?>, '<?php echo e($deposit->user->wallet_address ?? 'N/A'); ?>')"><?php echo e(__('admin.deposits.confirm')); ?></button>
                            <form method="POST" action="<?php echo e(route('admin.deposits.update', $deposit->id)); ?>" style="display:inline-block;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <input type="hidden" name="status" value="rejected">
                                <textarea name="reason" placeholder="<?php echo e(__('admin.deposits.rejection_reason')); ?>" required class="form-control-sm" rows="2" style="width: 200px; margin-bottom: 6px;"></textarea>
                                <button type="submit" class="btn btn-sm btn-danger"><?php echo e(__('admin.deposits.reject')); ?></button>
                            </form>
                        </div>
                        <?php else: ?>
                        <span class="text-muted"><?php echo e(__('admin.deposits.' . $deposit->status)); ?></span>
                        <?php if($deposit->admin_note): ?>
                        <br><small class="text-muted" style="font-size: 11px;"><?php echo e(Str::limit($deposit->admin_note, 30)); ?></small>
                        <?php endif; ?>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center"><?php echo e(__('admin.deposits.no_found')); ?></td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo $__env->make('admin.partials.pagination', ['items' => $deposits], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<!-- Confirm Deposit Modal -->
<div id="confirmModal" class="modal-backdrop" style="display: none;" onclick="closeConfirmModal()">
    <div class="modal-card" onclick="event.stopPropagation();">
        <div class="modal-header">
            <h3 class="modal-title"><?php echo e(__('admin.deposits.confirm_modal_title')); ?></h3>
        </div>
        <div class="modal-body">
            <p style="color: var(--text); margin: 0 0 12px 0;"><?php echo e(__('admin.deposits.confirm_question')); ?></p>
            <div style="background: rgba(255, 255, 255, 0.05); padding: 12px; border-radius: 8px; margin-bottom: 12px;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 6px;">
                    <span style="color: var(--muted); font-size: 13px;"><?php echo e(__('admin.deposits.amount')); ?>:</span>
                    <span style="color: var(--text); font-weight: 600;" id="confirmAmount">$0.00</span>
                </div>
                <div style="display: flex; justify-content: space-between;">
                    <span style="color: var(--muted); font-size: 13px;"><?php echo e(__('admin.deposits.user')); ?>:</span>
                    <span style="color: var(--text); font-size: 13px;" id="confirmUser">N/A</span>
                </div>
            </div>
            <p style="color: var(--muted); margin: 0; font-size: 12px;"><?php echo e(__('admin.deposits.confirm_note')); ?></p>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-outline" onclick="closeConfirmModal()"><?php echo e(__('admin.common.cancel')); ?></button>
            <form id="confirmForm" method="POST" style="display: inline;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="status" value="confirmed">
                <button type="submit" class="btn btn-success"><?php echo e(__('admin.deposits.confirm_btn')); ?></button>
            </form>
        </div>
    </div>
</div>

<!-- Voucher View Modal -->
<div id="voucherModal" class="modal-backdrop" style="display: none;" onclick="closeVoucherModal()">
    <div class="modal-card voucher-modal" onclick="event.stopPropagation();">
        <div class="modal-header">
            <h3><?php echo e(__('admin.deposits.transaction_voucher')); ?></h3>
            <button type="button" class="modal-close" onclick="closeVoucherModal()">×</button>
        </div>
        <div class="modal-body voucher-modal-body">
            <img id="voucherImage" src="" alt="Voucher" class="voucher-image">
        </div>
    </div>
</div>

<script>
let currentConfirmDepositId = null;

function showConfirmModal(depositId, amount, userAddress) {
    currentConfirmDepositId = depositId;
    document.getElementById('confirmAmount').textContent = '$' + parseFloat(amount).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    document.getElementById('confirmUser').textContent = userAddress ? (userAddress.substring(0, 10) + '...') : 'N/A';
    document.getElementById('confirmForm').action = '<?php echo e(route("admin.deposits.update", ":id")); ?>'.replace(':id', depositId);
    document.getElementById('confirmModal').style.display = 'flex';
}

function closeConfirmModal() {
    document.getElementById('confirmModal').style.display = 'none';
    currentConfirmDepositId = null;
}

function viewVoucher(imageUrl) {
    document.getElementById('voucherImage').src = imageUrl;
    document.getElementById('voucherModal').style.display = 'flex';
}

function closeVoucherModal() {
    document.getElementById('voucherModal').style.display = 'none';
}

// Close confirm modal on backdrop click
document.getElementById('confirmModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeConfirmModal();
    }
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/deposits/index.blade.php ENDPATH**/ ?>