<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
<div class="alert alert-success" style="background: var(--primary-soft); color: var(--primary); padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid var(--primary);">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<div class="grid-2">
    <div class="panel-card">
        <div class="panel-header">
            <h2><?php echo e(__('admin.notifications.send_title')); ?></h2>
            <form method="GET" action="<?php echo e(route('admin.notifications')); ?>" class="search-form">
                <input type="text" name="search" placeholder="<?php echo e(__('admin.notifications.search_placeholder')); ?>" value="<?php echo e(request('search')); ?>">
                <button type="submit"><?php echo e(__('admin.notifications.search')); ?></button>
            </form>
        </div>
        <div class="panel-body">
            <form method="POST" action="<?php echo e(route('admin.notifications.send')); ?>" id="sendNotiForm">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label><?php echo e(__('admin.notifications.message_type')); ?></label>
                    <select name="message_type" class="form-control" required>
                        <option value="maintenance"><?php echo e(__('admin.notifications.maintenance')); ?></option>
                        <option value="success"><?php echo e(__('admin.notifications.success')); ?></option>
                        <option value="info"><?php echo e(__('admin.notifications.info')); ?></option>
                        <option value="custom"><?php echo e(__('admin.notifications.custom')); ?></option>
                    </select>
                </div>
                <div class="form-group">
                    <label><?php echo e(__('admin.notifications.title_label')); ?></label>
                    <input type="text" name="title" class="form-control" maxlength="255" required placeholder="<?php echo e(__('admin.notifications.title_placeholder')); ?>">
                </div>
                <div class="form-group">
                    <label><?php echo e(__('admin.notifications.message_label')); ?></label>
                    <textarea name="message" class="form-control" rows="4" maxlength="5000" required placeholder="<?php echo e(__('admin.notifications.message_placeholder')); ?>"></textarea>
                </div>
                <div class="form-group">
                    <label><?php echo e(__('admin.notifications.select_users')); ?></label>
                    <div style="max-height: 320px; overflow-y: auto; border: 1px solid var(--border); border-radius: 8px; padding: 12px;">
                        <label style="display: block; margin-bottom: 8px;"><input type="checkbox" id="selectAllUsers"> <?php echo e(__('admin.notifications.select_all_page')); ?></label>
                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <label style="display: flex; align-items: center; gap: 8px; padding: 6px 0;">
                            <input type="checkbox" name="user_ids[]" value="<?php echo e($user->id); ?>" class="user-checkbox">
                            <span>#<?php echo e($user->id); ?> <?php echo e(Str::limit($user->wallet_address, 12)); ?> (<?php echo e(Str::limit($user->name, 15)); ?>)</span>
                        </label>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted"><?php echo e(__('admin.notifications.no_users_found')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary"><?php echo e(__('admin.notifications.send_notification')); ?></button>
            </form>
        </div>
        <?php echo $__env->make('admin.partials.pagination', ['items' => $users], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <div class="panel-card">
        <div class="panel-header">
            <h2><?php echo e(__('admin.notifications.templates_title')); ?></h2>
        </div>
        <div class="panel-body">
            <p class="text-muted" style="font-size: 13px; margin-bottom: 16px;"><?php echo e(__('admin.notifications.templates_note')); ?></p>
            <form method="POST" action="<?php echo e(route('admin.notifications.templates')); ?>">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label><?php echo e(__('admin.notifications.welcome_title')); ?></label>
                    <input type="text" name="notification_welcome_title" class="form-control" value="<?php echo e($templates['notification_welcome_title'] ?? ''); ?>" placeholder="Welcome to AI Quantification Trading">
                </div>
                <div class="form-group">
                    <label><?php echo e(__('admin.notifications.welcome_message')); ?></label>
                    <textarea name="notification_welcome_message" class="form-control" rows="3" placeholder="Welcome message for new users"><?php echo e($templates['notification_welcome_message'] ?? ''); ?></textarea>
                </div>
                <div class="form-group">
                    <label><?php echo e(__('admin.notifications.deposit_approved_title')); ?></label>
                    <input type="text" name="notification_deposit_approved_title" class="form-control" value="<?php echo e($templates['notification_deposit_approved_title'] ?? ''); ?>" placeholder="Deposit Approved">
                </div>
                <div class="form-group">
                    <label><?php echo e(__('admin.notifications.deposit_approved_message')); ?></label>
                    <textarea name="notification_deposit_approved_message" class="form-control" rows="3" placeholder="Message when deposit is approved"><?php echo e($templates['notification_deposit_approved_message'] ?? ''); ?></textarea>
                </div>
                <div class="form-group">
                    <label><?php echo e(__('admin.notifications.withdrawal_approved_title')); ?></label>
                    <input type="text" name="notification_withdraw_approved_title" class="form-control" value="<?php echo e($templates['notification_withdraw_approved_title'] ?? ''); ?>" placeholder="Withdrawal Completed">
                </div>
                <div class="form-group">
                    <label><?php echo e(__('admin.notifications.withdrawal_approved_message')); ?></label>
                    <textarea name="notification_withdraw_approved_message" class="form-control" rows="3" placeholder="Message when withdrawal is approved"><?php echo e($templates['notification_withdraw_approved_message'] ?? ''); ?></textarea>
                </div>
                <button type="submit" class="btn btn-primary"><?php echo e(__('admin.notifications.save_templates')); ?></button>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('selectAllUsers')?.addEventListener('change', function() {
    document.querySelectorAll('.user-checkbox').forEach(cb => cb.checked = this.checked);
});
document.getElementById('sendNotiForm')?.addEventListener('submit', function(e) {
    const checked = document.querySelectorAll('.user-checkbox:checked').length;
    if (checked === 0) {
        e.preventDefault();
        alert('Please select at least one user.');
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/notifications/index.blade.php ENDPATH**/ ?>