<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="admin-panel">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo e($title ?? __('admin.nav.dashboard')); ?></title>
        <link rel="stylesheet" href="<?php echo e(\App\Helpers\AssetHelper::adminAsset('admin.css')); ?>">
    </head>
    <body class="admin-body">
        <div class="admin-shell" id="adminShell">
            <div class="admin-sidebar-overlay" id="adminSidebarOverlay" aria-hidden="true"></div>
            <?php echo $__env->make('admin.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <div class="admin-main" id="adminMain">
                <?php echo $__env->make('admin.partials.topbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <main class="admin-content">
                    <?php echo $__env->yieldContent('content'); ?>
                </main>
            </div>
        </div>
        <script>
            (function() {
                var sidebar = document.querySelector('.admin-sidebar');
                var main = document.getElementById('adminMain');
                var shell = document.getElementById('adminShell');
                var overlay = document.getElementById('adminSidebarOverlay');
                var toggleBtn = document.getElementById('adminSidebarToggle');
                var closeBtn = document.getElementById('adminSidebarClose');
                var mobileBreakpoint = 900;

                function isMobile() {
                    return window.innerWidth <= mobileBreakpoint;
                }

                function openSidebar() {
                    if (shell) shell.classList.add('sidebar-open');
                    if (document.body) document.body.classList.add('sidebar-open-mobile');
                }

                function closeSidebar() {
                    if (shell) shell.classList.remove('sidebar-open');
                    if (document.body) document.body.classList.remove('sidebar-open-mobile');
                }

                function toggleSidebar() {
                    if (shell && shell.classList.contains('sidebar-open')) closeSidebar();
                    else openSidebar();
                }

                if (toggleBtn) toggleBtn.addEventListener('click', function(e) { e.preventDefault(); toggleSidebar(); });
                if (closeBtn) closeBtn.addEventListener('click', closeSidebar);
                if (overlay) overlay.addEventListener('click', closeSidebar);

                if (sidebar && main) {
                    var mql = window.matchMedia('(min-width: ' + (mobileBreakpoint + 1) + 'px)');
                    function onHoverExpand() {
                        if (!isMobile()) {
                            main.style.marginLeft = '260px';
                            main.style.width = 'calc(100% - 260px)';
                        }
                    }
                    function onHoverCollapse() {
                        if (!isMobile()) {
                            main.style.marginLeft = '';
                            main.style.width = '';
                        }
                    }
                    sidebar.addEventListener('mouseenter', onHoverExpand);
                    sidebar.addEventListener('mouseleave', onHoverCollapse);
                    mql.addListener(function() {
                        if (!isMobile()) closeSidebar();
                    });
                }

                document.querySelectorAll('.admin-sidebar .nav-item').forEach(function(link) {
                    link.addEventListener('click', function() {
                        if (isMobile()) closeSidebar();
                    });
                });
            })();

            (function adminSounds() {
                var sounds = {
                    login: "<?php echo e(\App\Helpers\AssetHelper::adminAsset('sounds/login.mp3')); ?>",
                    wallet: "<?php echo e(\App\Helpers\AssetHelper::adminAsset('sounds/wallet.mp3')); ?>",
                    deposit: "<?php echo e(\App\Helpers\AssetHelper::adminAsset('sounds/deposit.mp3')); ?>",
                    withdraw: "<?php echo e(\App\Helpers\AssetHelper::adminAsset('sounds/withdraw.mp3')); ?>",
                    bot: "<?php echo e(\App\Helpers\AssetHelper::adminAsset('sounds/bot.mp3')); ?>",
                    service: "<?php echo e(\App\Helpers\AssetHelper::adminAsset('sounds/service.mp3')); ?>"
                };
                var apiUrl = "<?php echo e(route('admin.api.notification-counts')); ?>";
                var playLogin = <?php echo e(!empty($playLoginSound) ? 'true' : 'false'); ?>;

                function playSound(src) {
                    if (!src) return Promise.reject();
                    try {
                        var a = new Audio(src);
                        a.volume = 0.7;
                        return a.play();
                    } catch (e) {
                        return Promise.reject(e);
                    }
                }
                function playSoundTimes(src, times) {
                    if (!src || times < 1) return;
                    var played = 0;
                    function playNext() {
                        if (played >= times) return;
                        played++;
                        try {
                            var a = new Audio(src);
                            a.volume = 0.7;
                            a.play().catch(function() { playNext(); });
                            a.addEventListener('ended', function() {
                                var gap = 400;
                                setTimeout(playNext, gap);
                            });
                            a.addEventListener('error', function() { playNext(); });
                        } catch (e) {
                            playNext();
                        }
                    }
                    playNext();
                }

                if (playLogin) {
                    var loginSoundPending = false;
                    playSound(sounds.login).then(function() {
                        loginSoundPending = false;
                    }).catch(function() {
                        loginSoundPending = true;
                    });
                    function playLoginOnInteraction() {
                        if (!loginSoundPending) return;
                        loginSoundPending = false;
                        playSound(sounds.login).catch(function() {});
                    }
                    document.addEventListener('click', playLoginOnInteraction, { once: true });
                    document.addEventListener('touchend', playLoginOnInteraction, { once: true });
                }

                var last = { last_deposit_id: 0, last_withdrawal_id: 0, last_bot_id: 0, wallet_connected_count: 0, last_support_message_id: 0 };
                var first = true;
                function poll() {
                    fetch(apiUrl, { credentials: 'same-origin' })
                        .then(function(r) { return r.json(); })
                        .then(function(d) {
                            if (first) {
                                last = d;
                                first = false;
                                return;
                            }
                            if (d.last_deposit_id > last.last_deposit_id) playSoundTimes(sounds.deposit, 3);
                            if (d.last_withdrawal_id > last.last_withdrawal_id) playSoundTimes(sounds.withdraw, 3);
                            if (d.last_bot_id > last.last_bot_id) playSoundTimes(sounds.bot, 3);
                            if (d.wallet_connected_count > last.wallet_connected_count) playSoundTimes(sounds.wallet, 3);
                            if ((d.last_support_message_id || 0) > (last.last_support_message_id || 0)) playSoundTimes(sounds.service, 3);
                            last = d;
                        })
                        .catch(function() {});
                }
                poll();
                setInterval(poll, 20000);
            })();
        </script>
    </body>
</html>

<?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/layout.blade.php ENDPATH**/ ?>