

<?php $__env->startSection('content'); ?>
<div class="panel-card">
    <div class="panel-header">
        <h2>Ticket #<?php echo e($ticket->id); ?></h2>
        <div style="display: flex; gap: 12px; align-items: center;">
            <form method="POST" action="<?php echo e(route('admin.support.update-status', $ticket->id)); ?>" style="display: inline;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <select name="status" class="form-control" onchange="this.form.submit()">
                    <option value="open" <?php echo e($ticket->status == 'open' ? 'selected' : ''); ?>>Open</option>
                    <option value="pending" <?php echo e($ticket->status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="resolved" <?php echo e($ticket->status == 'resolved' ? 'selected' : ''); ?>>Resolved</option>
                    <option value="closed" <?php echo e($ticket->status == 'closed' ? 'selected' : ''); ?>>Closed</option>
                </select>
            </form>
            <a href="<?php echo e(route('admin.support')); ?>" class="btn btn-outline">Back</a>
        </div>
    </div>
    <div class="panel-body">
        <div style="margin-bottom: 24px; padding: 16px; background: var(--card); border-radius: 8px;">
            <h3 style="margin: 0 0 12px 0;">User Information</h3>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 12px;">
                <div>
                    <strong>Wallet Address:</strong><br>
                    <span class="text-muted"><?php echo e($ticket->user->wallet_address ?? 'N/A'); ?></span>
                </div>
                <div>
                    <strong>Email:</strong><br>
                    <span class="text-muted"><?php echo e($ticket->user->email ?? 'N/A'); ?></span>
                </div>
                <div>
                    <strong>User ID:</strong><br>
                    <span class="text-muted"><?php echo e($ticket->user->id); ?></span>
                </div>
                <div>
                    <strong>Created:</strong><br>
                    <span class="text-muted"><?php echo e($ticket->created_at->format('Y-m-d H:i:s')); ?></span>
                </div>
            </div>
        </div>

        <div style="margin-bottom: 24px;">
            <h3 style="margin: 0 0 16px 0;">Chat Messages</h3>
            <div style="max-height: 500px; overflow-y: auto; padding: 16px; background: var(--bg); border-radius: 8px; border: 1px solid var(--border);">
                <?php $__currentLoopData = $ticket->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div style="margin-bottom: 16px; display: flex; <?php echo e($message->sender_type === 'user' ? 'flex-direction: row-reverse;' : ''); ?>">
                        <div style="max-width: 70%; padding: 12px; background: <?php echo e($message->sender_type === 'user' ? 'var(--primary)' : 'var(--card)'); ?>; border-radius: 8px; <?php echo e($message->sender_type === 'user' ? 'border-top-right-radius: 4px;' : 'border-top-left-radius: 4px;'); ?>">
                            <?php if($message->image): ?>
                                <div style="margin-bottom: 8px;">
                                    <img src="<?php echo e(asset('storage/' . $message->image)); ?>" alt="Attachment" style="max-width: 200px; border-radius: 4px;">
                                </div>
                            <?php endif; ?>
                            <?php if($message->message): ?>
                                <div style="white-space: pre-wrap; word-wrap: break-word; color: <?php echo e($message->sender_type === 'user' ? 'var(--bg)' : 'var(--text)'); ?>;">
                                    <?php echo e($message->message); ?>

                                </div>
                            <?php endif; ?>
                            <div style="font-size: 11px; color: var(--muted); margin-top: 4px;">
                                <?php echo e($message->created_at->format('H:i')); ?>

                                <?php if($message->sender_type === 'admin'): ?>
                                    - <?php echo e($message->sender->name ?? 'Admin'); ?>

                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <div>
            <h3 style="margin: 0 0 16px 0;">Send Message</h3>
            <form method="POST" action="<?php echo e(route('admin.support.send-message', $ticket->id)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div style="margin-bottom: 12px;">
                    <textarea name="message" class="form-control" rows="3" placeholder="Type your message..." required></textarea>
                </div>
                <div style="margin-bottom: 12px;">
                    <label>
                        <input type="file" name="image" accept="image/*" style="display: none;" onchange="this.parentElement.querySelector('span').textContent = this.files[0] ? this.files[0].name : 'Select image'">
                        <span class="btn btn-outline">Select Image</span>
                    </label>
                </div>
                <button type="submit" class="btn btn-primary">Send Message</button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/support/show.blade.php ENDPATH**/ ?>