

<?php $__env->startSection('content'); ?>
<div class="panel-card">
    <div class="panel-header">
        <h2><?php echo e(__('admin.withdrawals.title')); ?></h2>
        <form method="GET" action="<?php echo e(route('admin.withdrawals')); ?>" class="search-form">
            <select name="status">
                <option value=""><?php echo e(__('admin.users.all_status')); ?></option>
                <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>><?php echo e(__('admin.deposits.pending')); ?></option>
                <option value="processing" <?php echo e(request('status') === 'processing' ? 'selected' : ''); ?>><?php echo e(__('admin.withdrawals.processing')); ?></option>
                <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>><?php echo e(__('admin.withdrawals.completed')); ?></option>
                <option value="rejected" <?php echo e(request('status') === 'rejected' ? 'selected' : ''); ?>><?php echo e(__('admin.withdrawals.rejected')); ?></option>
            </select>
            <button type="submit"><?php echo e(__('admin.withdrawals.filter')); ?></button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th><?php echo e(__('admin.table.id')); ?></th>
                    <th><?php echo e(__('admin.withdrawals.user')); ?></th>
                    <th><?php echo e(__('admin.withdrawals.coin')); ?></th>
                    <th><?php echo e(__('admin.withdrawals.network')); ?></th>
                    <th><?php echo e(__('admin.withdrawals.address')); ?></th>
                    <th><?php echo e(__('admin.withdrawals.amount')); ?></th>
                    <th><?php echo e(__('admin.withdrawals.status')); ?></th>
                    <th><?php echo e(__('admin.withdrawals.date')); ?></th>
                    <th><?php echo e(__('admin.table.actions')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e(str_pad($withdrawal->user->id, 6, '0', STR_PAD_LEFT)); ?></td>
                    <td><?php echo e(substr($withdrawal->user->wallet_address ?? 'N/A', 0, 10)); ?>...</td>
                    <td><strong><?php echo e($withdrawal->coin_name); ?></strong></td>
                    <td><span class="badge badge-info"><?php echo e($withdrawal->network); ?></span></td>
                    <td class="withdraw-address-cell">
                        <span class="withdraw-address-text" title="<?php echo e($withdrawal->address); ?>"><?php echo e($withdrawal->address); ?></span>
                        <button type="button" class="btn btn-sm btn-outline copy-address-btn" data-address="<?php echo e(e($withdrawal->address)); ?>" title="<?php echo e(__('admin.withdrawals.copy_address')); ?>">Copy</button>
                    </td>
                    <td>$<?php echo e(number_format($withdrawal->amount, 2)); ?></td>
                    <td>
                        <span class="badge badge-<?php echo e($withdrawal->status === 'completed' ? 'success' : ($withdrawal->status === 'rejected' ? 'danger' : 'warning')); ?>">
                            <?php echo e(__('admin.withdrawals.' . $withdrawal->status)); ?>

                        </span>
                    </td>
                    <td><?php echo e($withdrawal->created_at->format('Y-m-d H:i')); ?></td>
                    <td>
                        <?php if(in_array($withdrawal->status, ['pending', 'processing'])): ?>
                        <form method="POST" action="<?php echo e(route('admin.withdrawals.update', $withdrawal->id)); ?>" style="display:inline;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="hidden" name="status" value="completed">
                            <button type="submit" class="btn btn-sm btn-success"><?php echo e(__('admin.withdrawals.complete')); ?></button>
                        </form>
                        <form method="POST" action="<?php echo e(route('admin.withdrawals.update', $withdrawal->id)); ?>" style="display:inline;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="hidden" name="status" value="rejected">
                            <textarea name="reason" placeholder="<?php echo e(__('admin.withdrawals.reason')); ?>" required class="form-control-sm"></textarea>
                            <button type="submit" class="btn btn-sm btn-danger"><?php echo e(__('admin.withdrawals.reject')); ?></button>
                        </form>
                        <?php else: ?>
                        <span class="text-muted"><?php echo e(__('admin.withdrawals.processed')); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="9" class="text-center"><?php echo e(__('admin.withdrawals.no_found')); ?></td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo $__env->make('admin.partials.pagination', ['items' => $withdrawals], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<style>
.withdraw-address-cell {
    max-width: 280px;
    vertical-align: middle;
}
.withdraw-address-text {
    display: inline-block;
    word-break: break-all;
    font-size: 12px;
    margin-right: 8px;
    vertical-align: middle;
}
.withdraw-address-cell .copy-address-btn {
    white-space: nowrap;
    flex-shrink: 0;
}
</style>
<script>
(function() {
    document.querySelectorAll('.copy-address-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            var address = this.getAttribute('data-address');
            if (!address) return;
            if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(address).then(function() {
                    var t = btn.textContent;
                    btn.textContent = 'Copied!';
                    setTimeout(function() { btn.textContent = t; }, 1500);
                }).catch(function() {
                    fallbackCopy(address, btn);
                });
            } else {
                fallbackCopy(address, btn);
            }
        });
    });
    function fallbackCopy(text, btn) {
        var ta = document.createElement('textarea');
        ta.value = text;
        ta.style.position = 'fixed';
        ta.style.left = '-9999px';
        document.body.appendChild(ta);
        ta.select();
        try {
            document.execCommand('copy');
            var t = btn.textContent;
            btn.textContent = 'Copied!';
            setTimeout(function() { btn.textContent = t; }, 1500);
        } catch (e) {}
        document.body.removeChild(ta);
    }
})();
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/withdrawals/index.blade.php ENDPATH**/ ?>