<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
<div class="alert alert-success" style="background: var(--primary-soft); color: var(--primary); padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid var(--primary);">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<div class="panel-card">
    <div class="panel-header" style="flex-wrap: wrap; gap: 12px;">
        <div style="display: flex; align-items: center; gap: 12px; flex-wrap: wrap;">
            <h2 style="margin: 0;">Discover</h2>
            <a href="<?php echo e(route('admin.discover', ['tab' => 'demo'])); ?>" class="btn <?php echo e(($tab ?? 'demo') === 'demo' ? 'btn-primary' : 'btn-outline'); ?>" style="padding: 6px 14px;"><?php echo e(__('admin.common.discover_posts_tab')); ?></a>
            <a href="<?php echo e(route('admin.discover', ['tab' => 'users'])); ?>" class="btn <?php echo e(($tab ?? '') === 'users' ? 'btn-primary' : 'btn-outline'); ?>" style="padding: 6px 14px;"><?php echo e(__('admin.common.users_discover_tab')); ?></a>
        </div>
        <?php if(($tab ?? 'demo') === 'demo'): ?>
        <a href="<?php echo e(route('admin.discover.create')); ?>" class="btn btn-primary"><?php echo e(__('admin.common.add_demo_post_btn')); ?></a>
        <?php endif; ?>
    </div>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th><?php echo e(__('admin.table.id')); ?></th>
                    <th><?php echo e(__('admin.table.author')); ?></th>
                    <th><?php echo e(__('admin.table.content')); ?></th>
                    <th><?php echo e(__('admin.table.likes')); ?></th>
                    <th><?php echo e(__('admin.table.comments')); ?></th>
                    <th><?php echo e(__('admin.table.created')); ?></th>
                    <th><?php echo e(__('admin.table.actions')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php $isDemo = $post->user_id === null; ?>
                <tr>
                    <td><?php echo e($post->id); ?></td>
                    <td><?php echo e($post->user_id ? 'User ' . $post->user_id : 'User ' . $post->demo_author_id); ?></td>
                    <td><?php echo e(Str::limit($post->content, 60)); ?></td>
                    <td><?php echo e($post->likes_count ?? 0); ?></td>
                    <td><?php echo e($post->comments_count ?? 0); ?></td>
                    <td><?php echo e($post->created_at->format('Y-m-d H:i')); ?></td>
                    <td>
                        <?php if($isDemo): ?>
                        <a href="<?php echo e(route('admin.discover.edit', $post->id)); ?>" class="btn btn-sm btn-primary"><?php echo e(__('admin.common.edit')); ?></a>
                        <form method="POST" action="<?php echo e(route('admin.discover.destroy', $post->id)); ?>" style="display: inline;" onsubmit="return confirm('<?php echo e(addslashes(__('admin.common.delete_confirm_post'))); ?>');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="hidden" name="_redirect_tab" value="<?php echo e($tab ?? 'demo'); ?>">
                            <button type="submit" class="btn btn-sm btn-danger"><?php echo e(__('admin.common.delete')); ?></button>
                        </form>
                        <?php else: ?>
                        <form method="POST" action="<?php echo e(route('admin.discover.destroy', $post->id)); ?>" style="display: inline;" onsubmit="return confirm('<?php echo e(addslashes(__('admin.common.delete_confirm_user_post'))); ?>');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="hidden" name="_redirect_tab" value="<?php echo e($tab ?? 'demo'); ?>">
                            <button type="submit" class="btn btn-sm btn-danger"><?php echo e(__('admin.common.delete')); ?></button>
                        </form>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <td colspan="7" style="background: var(--bg); padding: 12px;">
                        <strong><?php echo e(__('admin.common.add_comment_as_demo')); ?></strong>
                        <?php if(!empty($demoAuthorIds)): ?>
                        <form method="POST" action="<?php echo e(route('admin.discover.comments.store', $post->id)); ?>" style="display: flex; gap: 8px; margin-top: 8px; flex-wrap: wrap; align-items: center;">
                            <?php echo csrf_field(); ?>
                            <label class="mb-0" style="font-weight: 500;"><?php echo e(__('admin.common.choose_id')); ?></label>
                            <select name="demo_author_id" class="form-control" required style="width: auto; min-width: 140px;">
                                <?php $__currentLoopData = $demoAuthorIds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aid): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($aid); ?>" <?php echo e(($isDemo && (string)$post->demo_author_id === (string)$aid) ? 'selected' : ''); ?>>User <?php echo e($aid); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="text" name="body" class="form-control" placeholder="<?php echo e(__('admin.common.comment_placeholder')); ?>" required style="flex: 1; min-width: 200px;">
                            <button type="submit" class="btn btn-sm btn-primary"><?php echo e(__('admin.common.add_comment')); ?></button>
                        </form>
                        <?php else: ?>
                        <p class="text-muted mb-0 mt-2"><?php echo e(__('admin.common.no_demo_authors')); ?></p>
                        <?php endif; ?>
                        <div style="margin-top: 12px; padding-top: 12px; border-top: 1px solid var(--border);">
                            <strong><?php echo e(__('admin.common.add_likes')); ?></strong>
                            <form method="POST" action="<?php echo e(route('admin.discover.likes.store', $post->id)); ?>" style="display: inline-flex; gap: 8px; margin-top: 6px; align-items: center; flex-wrap: wrap;">
                                <?php echo csrf_field(); ?>
                                <input type="number" name="count" value="1" min="1" max="500" class="form-control" style="width: 80px;">
                                <button type="submit" class="btn btn-sm btn-primary"><?php echo e(__('admin.common.add_like')); ?></button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center">
                        <?php if(($tab ?? 'demo') === 'users'): ?>
                        <?php echo e(__('admin.common.no_user_posts')); ?>

                        <?php else: ?>
                        <?php echo e(__('admin.common.no_demo_posts')); ?> <a href="<?php echo e(route('admin.discover.create')); ?>"><?php echo e(__('admin.common.add_demo_post')); ?></a>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php echo $__env->make('admin.partials.pagination', ['items' => $posts], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/discover/index.blade.php ENDPATH**/ ?>