<?php $__env->startSection('content'); ?>
<div class="panel-card">
    <div class="panel-header">
        <h2>Edit Announcement</h2>
        <a href="<?php echo e(route('admin.announcements')); ?>" class="btn btn-outline">Back</a>
    </div>
    <div class="panel-body">
        <form method="POST" action="<?php echo e(route('admin.announcements.update', $post->id)); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="form-group">
                <label>Author (read-only)</label>
                <input type="text" class="form-control" value="AI Bot" readonly>
            </div>
            <div class="form-group">
                <label>Content</label>
                <textarea name="content" class="form-control" rows="5" required><?php echo e($post->content); ?></textarea>
            </div>
            <div class="form-group">
                <label>Current image</label>
                <?php if($post->image_path): ?>
                <div style="margin-bottom: 8px;"><img src="<?php echo e(asset('storage/' . $post->image_path)); ?>" alt="Post" style="max-width: 200px; border-radius: 8px;"></div>
                <?php else: ?>
                <p class="text-muted">No image</p>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label>Replace image (optional)</label>
                <input type="file" name="image" id="editAnnImage" accept="image/*" class="form-control">
                <div id="editAnnImagePreview" style="margin-top: 10px; display: none;">
                    <span style="font-size: 13px; color: var(--muted);">Preview:</span>
                    <div style="margin-top: 6px;"><img id="editAnnImagePreviewImg" src="" alt="Preview" style="max-width: 280px; max-height: 200px; object-fit: contain; border-radius: 8px; border: 1px solid var(--border);"></div>
                </div>
            </div>
            <button type="submit" class="btn btn-primary">Update</button>
        </form>
    </div>
</div>
<script>
document.getElementById('editAnnImage').addEventListener('change', function() {
    var preview = document.getElementById('editAnnImagePreview');
    var img = document.getElementById('editAnnImagePreviewImg');
    if (this.files && this.files[0]) {
        img.src = URL.createObjectURL(this.files[0]);
        preview.style.display = 'block';
    } else {
        img.src = '';
        preview.style.display = 'none';
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/announcements/edit.blade.php ENDPATH**/ ?>