

<?php $__env->startSection('content'); ?>
<?php
    use Illuminate\Support\Str;
?>
<div class="panel-card">
    <div class="panel-header">
        <h2>Customer Service Management</h2>
        <form class="search-form" method="GET" action="<?php echo e(route('admin.support')); ?>">
            <input type="text" name="search" placeholder="Search by wallet or email" value="<?php echo e(request('search')); ?>" class="form-control">
            <select name="status" class="form-control">
                <option value="">All Status</option>
                <option value="open" <?php echo e(request('status') == 'open' ? 'selected' : ''); ?>>Open</option>
                <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="resolved" <?php echo e(request('status') == 'resolved' ? 'selected' : ''); ?>>Resolved</option>
                <option value="closed" <?php echo e(request('status') == 'closed' ? 'selected' : ''); ?>>Closed</option>
            </select>
            <button type="submit" class="btn btn-primary">Filter</button>
            <?php if(request()->has('search') || request()->has('status')): ?>
                <a href="<?php echo e(route('admin.support')); ?>" class="btn btn-outline">Clear</a>
            <?php endif; ?>
        </form>
    </div>
    <div class="panel-body">
        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Last Message</th>
                        <th>Status</th>
                        <th>Priority</th>
                        <th>Last Activity</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>#<?php echo e($ticket->id); ?></td>
                            <td>
                                <div>
                                    <strong><?php echo e($ticket->user->wallet_address ?? 'N/A'); ?></strong><br>
                                    <small class="text-muted"><?php echo e($ticket->user->email ?? 'N/A'); ?></small>
                                </div>
                            </td>
                            <td>
                                <?php
                                    $latestMessage = $ticket->messages()->latest()->first();
                                ?>
                                <?php if($latestMessage): ?>
                                    <div class="text-truncate" style="max-width: 200px;">
                                        <?php echo e(Str::limit($latestMessage->message ?? 'Image attachment', 50)); ?>

                                    </div>
                                <?php else: ?>
                                    <span class="text-muted">No messages</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo e($ticket->status); ?>">
                                    <?php echo e(ucfirst($ticket->status)); ?>

                                </span>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo e($ticket->priority); ?>">
                                    <?php echo e(ucfirst($ticket->priority)); ?>

                                </span>
                            </td>
                            <td>
                                <?php echo e($ticket->last_message_at ? $ticket->last_message_at->diffForHumans() : $ticket->created_at->diffForHumans()); ?>

                            </td>
                            <td>
                                <a href="<?php echo e(route('admin.support.show', $ticket->id)); ?>" class="btn btn-sm btn-primary">View</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted">No support tickets found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo $__env->make('admin.partials.pagination', ['items' => $tickets], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/support/index.blade.php ENDPATH**/ ?>