

<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>
<?php if(session('error')): ?>
    <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
<?php endif; ?>
<div class="grid-2">
    <div class="panel-card">
        <div class="panel-header">
            <h2><?php echo e(__('admin.admins.title')); ?></h2>
        </div>

        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th><?php echo e(__('admin.table.id')); ?></th>
                        <th><?php echo e(__('admin.admins.username')); ?></th>
                        <th><?php echo e(__('admin.admins.email')); ?></th>
                        <th><?php echo e(__('admin.admins.role')); ?></th>
                        <th><?php echo e(__('admin.admins.status')); ?></th>
                        <th><?php echo e(__('admin.table.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($admin->id); ?></td>
                        <td><?php echo e($admin->username); ?></td>
                        <td><?php echo e($admin->email); ?></td>
                        <td>
                            <?php if($admin->role === 'super_admin'): ?>
                            <span class="badge badge-warning"><?php echo e(__('admin.admins.role_super_admin')); ?></span>
                            <?php elseif($admin->role === 'service_admin'): ?>
                            <span class="badge badge-secondary"><?php echo e(__('admin.admins.role_service_admin')); ?></span>
                            <?php else: ?>
                            <span class="badge badge-info"><?php echo e(__('admin.admins.role_admin')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge <?php echo e($admin->is_active ? 'badge-success' : 'badge-danger'); ?>">
                                <?php echo e($admin->is_active ? __('admin.admins.active') : __('admin.admins.inactive')); ?>

                            </span>
                        </td>
                        <td>
                            <button onclick="editAdmin(<?php echo e($admin->id); ?>)" class="btn btn-sm btn-primary"><?php echo e(__('admin.admins.edit')); ?></button>
                            <?php if($admin->role !== 'super_admin'): ?>
                            <form method="POST" action="<?php echo e(route('admin.admins.destroy', $admin->id)); ?>" style="display:inline;" onsubmit="return confirm(<?php echo e(json_encode(__('admin.admins.delete_confirm'))); ?>);">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger"><?php echo e(__('admin.admins.delete')); ?></button>
                            </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center"><?php echo e(__('admin.admins.no_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="panel-card">
        <div class="panel-header">
            <h2><?php echo e(__('admin.admins.add_edit_title')); ?></h2>
        </div>
        <div class="panel-body">
            <form method="POST" action="<?php echo e(route('admin.admins.store')); ?>" id="adminForm">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label><?php echo e(__('admin.admins.username')); ?></label>
                    <input type="text" name="username" class="form-control" required>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.admins.email')); ?></label>
                    <input type="email" name="email" class="form-control" required>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.admins.password')); ?></label>
                    <input type="password" name="password" class="form-control" required>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.admins.role')); ?></label>
                    <select name="role" class="form-control" required>
                        <option value="admin"><?php echo e(__('admin.admins.role_admin')); ?></option>
                        <option value="service_admin"><?php echo e(__('admin.admins.role_service_admin')); ?></option>
                        <option value="super_admin"><?php echo e(__('admin.admins.role_super_admin')); ?></option>
                    </select>
                </div>

                <button type="submit" class="btn btn-primary"><?php echo e(__('admin.admins.save_admin')); ?></button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/admins/index.blade.php ENDPATH**/ ?>