

<?php $__env->startSection('content'); ?>
<div class="panel-card">
    <div class="panel-header">
        <h2><?php echo e(__('admin.audit_logs.title')); ?></h2>
        <form method="GET" action="<?php echo e(route('admin.audit-logs')); ?>" class="search-form">
            <input type="number" name="admin_user_id" placeholder="<?php echo e(__('admin.audit_logs.admin_id_placeholder')); ?>" value="<?php echo e(request('admin_user_id')); ?>">
            <input type="text" name="action" placeholder="<?php echo e(__('admin.audit_logs.action_placeholder')); ?>" value="<?php echo e(request('action')); ?>">
            <button type="submit"><?php echo e(__('admin.audit_logs.filter')); ?></button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th><?php echo e(__('admin.table.id')); ?></th>
                    <th><?php echo e(__('admin.audit_logs.admin')); ?></th>
                    <th><?php echo e(__('admin.audit_logs.action')); ?></th>
                    <th><?php echo e(__('admin.audit_logs.model')); ?></th>
                    <th><?php echo e(__('admin.audit_logs.changes')); ?></th>
                    <th><?php echo e(__('admin.audit_logs.reason')); ?></th>
                    <th><?php echo e(__('admin.audit_logs.date')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($log->id); ?></td>
                    <td><?php echo e($log->adminUser->email ?? 'N/A'); ?></td>
                    <td><?php echo e($log->action); ?></td>
                    <td><?php echo e(class_basename($log->model_type)); ?> #<?php echo e($log->model_id); ?></td>
                    <td><?php echo e($log->changes); ?></td>
                    <td><?php echo e($log->reason); ?></td>
                    <td><?php echo e($log->created_at->format('Y-m-d H:i')); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center"><?php echo e(__('admin.audit_logs.no_found')); ?></td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo $__env->make('admin.partials.pagination', ['items' => $logs], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/audit-logs/index.blade.php ENDPATH**/ ?>