

<?php $__env->startSection('content'); ?>
<div class="panel-card">
    <div class="panel-header">
        <h2><?php echo e(__('admin.referrals.title')); ?></h2>
        <form method="GET" action="<?php echo e(route('admin.referrals')); ?>" class="search-form">
            <input type="number" name="user_id" placeholder="<?php echo e(__('admin.referrals.user_id_placeholder')); ?>" value="<?php echo e(request('user_id')); ?>">
            <button type="submit"><?php echo e(__('admin.referrals.filter')); ?></button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th><?php echo e(__('admin.table.id')); ?></th>
                    <th><?php echo e(__('admin.referrals.referrer')); ?></th>
                    <th><?php echo e(__('admin.referrals.referred_user')); ?></th>
                    <th><?php echo e(__('admin.referrals.level')); ?></th>
                    <th><?php echo e(__('admin.referrals.total_earnings')); ?></th>
                    <th><?php echo e(__('admin.referrals.date')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($referral->id); ?></td>
                    <td><?php echo e(substr($referral->user->wallet_address ?? 'N/A', 0, 10)); ?>...</td>
                    <td><?php echo e(substr($referral->referredUser->wallet_address ?? 'N/A', 0, 10)); ?>...</td>
                    <td><?php echo e($referral->level); ?></td>
                    <td>$<?php echo e(number_format($referral->total_earnings, 2)); ?></td>
                    <td><?php echo e($referral->created_at->format('Y-m-d')); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center"><?php echo e(__('admin.referrals.no_found')); ?></td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo $__env->make('admin.partials.pagination', ['items' => $referrals], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/referrals/index.blade.php ENDPATH**/ ?>