

<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
<div class="alert alert-success" style="background: var(--primary-soft); color: var(--primary); padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid var(--primary);">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<div class="grid-2">
    <div class="panel-card">
        <div class="panel-header">
            <h2><?php echo e(__('admin.users.user_information')); ?></h2>
        </div>
        <div class="panel-body">
            <div class="info-row">
                <span class="label"><?php echo e(__('admin.users.user_id')); ?>:</span>
                <span class="value" style="font-weight: 600; color: var(--primary); letter-spacing: 1px;"><?php echo e(str_pad($user->id, 6, '0', STR_PAD_LEFT)); ?></span>
            </div>
            <div class="info-row">
                <span class="label"><?php echo e(__('admin.users.wallet_address')); ?>:</span>
                <span class="value"><?php echo e($user->wallet_address); ?></span>
            </div>
            <div class="info-row">
                <span class="label"><?php echo e(__('admin.users.name')); ?>:</span>
                <span class="value"><?php echo e($user->name); ?></span>
            </div>
            <div class="info-row">
                <span class="label"><?php echo e(__('admin.users.email')); ?>:</span>
                <span class="value"><?php echo e($user->email); ?></span>
            </div>
            <div class="info-row">
                <span class="label"><?php echo e(__('admin.users.account_weight_score')); ?>:</span>
                <span class="value" style="display: flex; align-items: center; gap: 4px;">
                    <span>⭐</span>
                    <span style="font-weight: 600;"><?php echo e(number_format($user->account_weight_score, 2)); ?></span>
                </span>
            </div>
            <div class="info-row">
                <span class="label"><?php echo e(__('admin.users.balance')); ?>:</span>
                <span class="value">$<?php echo e(number_format($user->balance, 2)); ?></span>
            </div>
            <div class="info-row">
                <span class="label"><?php echo e(__('admin.users.locked_balance')); ?>:</span>
                <span class="value">$<?php echo e(number_format($user->locked_balance, 2)); ?></span>
            </div>
            <div class="info-row">
                <span class="label"><?php echo e(__('admin.users.status')); ?>:</span>
                <span class="value">
                    <span class="badge <?php echo e($user->is_active ? 'badge-success' : 'badge-danger'); ?>">
                        <?php echo e($user->is_active ? __('admin.users.active') : __('admin.users.inactive')); ?>

                    </span>
                </span>
            </div>
            <div class="info-row">
                <span class="label"><?php echo e(__('admin.users.verified')); ?>:</span>
                <span class="value">
                    <span class="badge <?php echo e($user->is_verified ? 'badge-success' : 'badge-warning'); ?>">
                        <?php echo e($user->is_verified ? __('admin.users.verified') : __('admin.users.pending')); ?>

                    </span>
                </span>
            </div>
            <div class="info-row">
                <span class="label"><?php echo e(__('admin.users.withdrawal_pin')); ?>:</span>
                <span class="value">
                    <span class="badge <?php echo e($user->withdrawal_pin_hash ? 'badge-success' : 'badge-warning'); ?>">
                        <?php echo e($user->withdrawal_pin_hash ? __('admin.users.set') : __('admin.users.not_set')); ?>

                    </span>
                </span>
            </div>
        </div>
    </div>

    <div class="panel-card">
        <div class="panel-header">
            <h2><?php echo e(__('admin.users.update_user')); ?></h2>
        </div>
        <div class="panel-body">
            <form method="POST" action="<?php echo e(route('admin.users.update', $user->id)); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <div class="form-group">
                    <label><?php echo e(__('admin.users.name')); ?></label>
                    <input type="text" name="name" value="<?php echo e($user->name); ?>" class="form-control">
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.users.status')); ?></label>
                    <select name="is_active" class="form-control">
                        <option value="1" <?php echo e($user->is_active ? 'selected' : ''); ?>><?php echo e(__('admin.users.active')); ?></option>
                        <option value="0" <?php echo e(!$user->is_active ? 'selected' : ''); ?>><?php echo e(__('admin.users.inactive')); ?></option>
                    </select>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.users.account_weight_score')); ?></label>
                    <div style="display: flex; gap: 10px; align-items: center;">
                        <input type="number" name="account_weight_score" value="<?php echo e($user->account_weight_score); ?>" step="1" min="0" max="100" class="form-control" style="flex: 1;">
                        <button type="button" onclick="adjustScore('increase')" class="btn btn-sm btn-success">+</button>
                        <button type="button" onclick="adjustScore('decrease')" class="btn btn-sm btn-warning">-</button>
                    </div>
                    <small class="text-muted">Range: 0 - 100</small>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.users.reason_required')); ?></label>
                    <textarea name="reason" class="form-control" rows="3" required></textarea>
                </div>

                <button type="submit" class="btn btn-primary"><?php echo e(__('admin.users.update_user')); ?></button>
            </form>

            <?php if(!$user->is_verified): ?>
            <form method="POST" action="<?php echo e(route('admin.users.verify', $user->id)); ?>" class="mt-3">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-success"><?php echo e(__('admin.users.verify_user_btn')); ?></button>
            </form>
            <?php endif; ?>

            <?php if($user->withdrawal_pin_hash): ?>
            <form method="POST" action="<?php echo e(route('admin.users.reset-pin', $user->id)); ?>" class="mt-3" onsubmit="return confirm(<?php echo e(json_encode(__('admin.users.reset_pin_confirm'))); ?>);">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-warning"><?php echo e(__('admin.users.reset_withdrawal_pin')); ?></button>
            </form>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
function adjustScore(action) {
    const scoreInput = document.querySelector('input[name="account_weight_score"]');
    let currentValue = parseFloat(scoreInput.value) || 0;
    
    if (action === 'increase') {
        currentValue = Math.min(100, currentValue + 1);
    } else {
        currentValue = Math.max(0, currentValue - 1);
    }
    
    scoreInput.value = currentValue;
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/users/show.blade.php ENDPATH**/ ?>