<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Admin Login</title>
        <link rel="stylesheet" href="<?php echo e(\App\Helpers\AssetHelper::adminAsset('admin.css')); ?>" type="text/css">
    </head>
    <body class="admin-login-body">
        <div class="login-shell">
            <div class="login-card">
                <div class="login-brand">Axue Admin</div>
                <div class="login-subtitle">Secure access for authorized admins</div>

                <?php if($errors->any()): ?>
                    <div class="alert alert-error"><?php echo e($errors->first()); ?></div>
                <?php endif; ?>

                <form method="post" action="<?php echo e(route('admin.login.submit')); ?>">
                    <?php echo csrf_field(); ?>
                    <label class="field">
                        <span>Email</span>
                        <input type="email" name="email" value="<?php echo e(old('email')); ?>" placeholder="admin@example.com" required>
                    </label>
                    <label class="field">
                        <span>Password</span>
                        <input type="password" name="password" placeholder="••••••••" required>
                    </label>
                    <button class="btn btn-primary full" type="submit">Login</button>
                </form>
            </div>
        </div>
    </body>
</html>

<?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/login.blade.php ENDPATH**/ ?>