

<?php $__env->startSection('content'); ?>
<div class="grid-2">
    <div class="panel-card">
        <div class="panel-header">
            <h2><?php echo e(__('admin.wallets.title')); ?></h2>
        </div>

        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th><?php echo e(__('admin.table.id')); ?></th>
                        <th><?php echo e(__('admin.wallets.name')); ?></th>
                        <th><?php echo e(__('admin.wallets.coin_name')); ?></th>
                        <th><?php echo e(__('admin.wallets.network')); ?></th>
                        <th><?php echo e(__('admin.wallets.address')); ?></th>
                        <th><?php echo e(__('admin.users.status')); ?></th>
                        <th><?php echo e(__('admin.table.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($wallet->id); ?></td>
                        <td><?php echo e($wallet->name); ?></td>
                        <td><strong><?php echo e($wallet->coin_name ?? 'USDT'); ?></strong></td>
                        <td><?php echo e($wallet->network); ?></td>
                        <td><?php echo e(substr($wallet->address, 0, 20)); ?>...</td>
                        <td>
                            <span class="badge <?php echo e($wallet->is_active ? 'badge-success' : 'badge-danger'); ?>">
                                <?php echo e($wallet->is_active ? __('admin.wallets.active') : __('admin.wallets.inactive')); ?>

                            </span>
                        </td>
                        <td>
                            <button onclick="editWallet(<?php echo e($wallet->id); ?>, '<?php echo e(addslashes($wallet->name)); ?>', '<?php echo e($wallet->coin_name ?? 'USDT'); ?>', '<?php echo e($wallet->network); ?>', '<?php echo e(addslashes($wallet->address)); ?>', '<?php echo e($wallet->qr_code_path ?? ''); ?>', <?php echo e($wallet->is_active ? 1 : 0); ?>)" class="btn btn-sm btn-primary"><?php echo e(__('admin.wallets.edit')); ?></button>
                            <?php if($wallet->qr_code_path): ?>
                            <button onclick="showQRCodeModal('<?php echo e(url('storage/' . $wallet->qr_code_path)); ?>', '<?php echo e($wallet->address); ?>', '<?php echo e($wallet->network); ?>')" class="btn btn-sm btn-info"><?php echo e(__('admin.wallets.view_qr')); ?></button>
                            <?php else: ?>
                            <span class="text-muted" style="font-size: 12px;"><?php echo e(__('admin.wallets.no_qr')); ?></span>
                            <?php endif; ?>
                            <form method="POST" action="<?php echo e(route('admin.wallets.destroy', $wallet->id)); ?>" style="display:inline;" onsubmit="return confirm(<?php echo e(json_encode(__('admin.wallets.delete_confirm'))); ?>);">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger"><?php echo e(__('admin.wallets.delete')); ?></button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center"><?php echo e(__('admin.wallets.no_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="panel-card">
        <div class="panel-header">
            <h2><?php echo e(__('admin.wallets.add_edit_title')); ?></h2>
        </div>
        <div class="panel-body">
            <form method="POST" action="<?php echo e(route('admin.wallets.store')); ?>" id="walletForm" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label><?php echo e(__('admin.wallets.name_optional')); ?></label>
                    <input type="text" name="name" id="wallet_name" class="form-control" placeholder="<?php echo e(__('admin.wallets.auto_generated_placeholder')); ?>">
                    <small class="text-muted"><?php echo e(__('admin.wallets.leave_empty_note')); ?></small>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.wallets.coin_name')); ?> <span style="color: #ef4444;">*</span></label>
                    <input type="text" name="coin_name" id="wallet_coin_name" class="form-control" required placeholder="<?php echo e(__('admin.wallets.coin_placeholder')); ?>" value="USDT">
                    <small class="text-muted"><?php echo e(__('admin.wallets.coin_hint')); ?></small>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.wallets.network')); ?> <span style="color: #ef4444;">*</span></label>
                    <input type="text" name="network" id="wallet_network" class="form-control" required placeholder="<?php echo e(__('admin.wallets.network_placeholder')); ?>">
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.wallets.address')); ?> <span style="color: #ef4444;">*</span></label>
                    <input type="text" name="address" id="wallet_address" class="form-control" required>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.wallets.qr_code_image')); ?></label>
                    <input type="file" name="qr_code" id="wallet_qr_code" accept="image/*" class="form-control" onchange="previewQRCode(this)">
                    <small class="text-muted"><?php echo e(__('admin.wallets.qr_upload_hint')); ?></small>
                    <div id="qr_preview" style="margin-top: 10px; display: none;">
                        <img id="qr_preview_img" src="" alt="QR Code Preview" style="max-width: 200px; max-height: 200px; border-radius: 8px; border: 1px solid var(--border);">
                        <button type="button" onclick="clearQRPreview()" class="btn btn-sm btn-outline" style="margin-top: 8px;"><?php echo e(__('admin.wallets.remove')); ?></button>
                    </div>
                    <div id="existing_qr_preview" style="margin-top: 10px;"></div>
                </div>

                <div class="form-group">
                    <label><?php echo e(__('admin.wallets.active')); ?></label>
                    <select name="is_active" class="form-control">
                        <option value="1"><?php echo e(__('admin.wallets.active')); ?></option>
                        <option value="0"><?php echo e(__('admin.wallets.inactive')); ?></option>
                    </select>
                </div>

                <button type="submit" class="btn btn-primary"><?php echo e(__('admin.wallets.save_wallet')); ?></button>
            </form>

            <script>
                // Auto-generate name from network if name is empty
                document.getElementById('wallet_network').addEventListener('input', function() {
                    const nameField = document.getElementById('wallet_name');
                    if (!nameField.value) {
                        nameField.value = this.value ? this.value + ' Wallet' : '';
                    }
                });
            </script>
        </div>
    </div>
</div>

<!-- QR Code Modal -->
<div id="qrModal" class="modal-backdrop" style="display: none;">
    <div class="modal-card">
        <div class="modal-header">
            <h3 class="modal-title" id="qrModalTitle"><?php echo e(__('admin.wallets.qr_code')); ?></h3>
            <button onclick="closeQRModal()" class="btn btn-sm btn-outline" style="position: absolute; right: 16px; top: 16px;">✕</button>
        </div>
        <div class="modal-body" style="text-align: center; padding: 20px;">
            <div id="qrCodeContainer" style="display: inline-block; padding: 20px; background: #fff; border-radius: 12px; margin-bottom: 16px; min-width: 256px; min-height: 256px; display: flex; align-items: center; justify-content: center;">
                <!-- QR code image will be inserted here -->
            </div>
            <div style="margin-bottom: 12px;">
                <div style="font-weight: 600; margin-bottom: 4px;" id="qrNetwork"></div>
                <div style="font-size: 12px; color: var(--muted); word-break: break-all;" id="qrAddress"></div>
            </div>
            <div style="display: flex; gap: 10px; justify-content: center;">
                <button onclick="downloadQRCode()" class="btn btn-primary"><?php echo e(__('admin.wallets.download_qr')); ?></button>
                <button onclick="copyQRAddress()" class="btn btn-outline"><?php echo e(__('admin.wallets.copy_address')); ?></button>
            </div>
        </div>
    </div>
</div>

<script>
let currentQRData = { address: '', network: '' };

function closeQRModal() {
    document.getElementById('qrModal').style.display = 'none';
}

function downloadQRCode() {
    const qrImg = document.querySelector('#qrCodeContainer img');
    if (qrImg && qrImg.src) {
        const link = document.createElement('a');
        link.download = currentQRData.network + '_qr.png';
        link.href = qrImg.src;
        link.click();
    }
}

function copyQRAddress() {
    navigator.clipboard.writeText(currentQRData.address).then(() => {
        alert('Address copied to clipboard');
    }).catch(err => {
        console.error('Copy failed:', err);
        alert('Failed to copy address');
    });
}

// Close modal on backdrop click
document.getElementById('qrModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeQRModal();
    }
});

function editWallet(id, name, coinName, network, address, qrCodePath, isActive) {
    // Populate form with wallet data
    document.getElementById('wallet_name').value = name;
    document.getElementById('wallet_coin_name').value = coinName || 'USDT';
    document.getElementById('wallet_network').value = network;
    document.getElementById('wallet_address').value = address;
    document.querySelector('select[name="is_active"]').value = isActive;
    
    // Show existing QR code if available
    if (qrCodePath) {
        const existingPreview = document.getElementById('existing_qr_preview');
        existingPreview.innerHTML = `
            <div style="margin-bottom: 8px;">
                <strong><?php echo e(__('admin.wallets.current_qr')); ?></strong>
            </div>
            <img src="/storage/${qrCodePath}" alt="Current QR Code" style="max-width: 200px; max-height: 200px; border-radius: 8px; border: 1px solid var(--border);">
        `;
    }
    
    // Change form action to update route
    const form = document.getElementById('walletForm');
    form.action = '<?php echo e(url("axue2026/admin/dashboard/wallets")); ?>/' + id;
    
    // Add method spoofing for PUT request
    if (!form.querySelector('input[name="_method"]')) {
        const methodInput = document.createElement('input');
        methodInput.type = 'hidden';
        methodInput.name = '_method';
        methodInput.value = 'PUT';
        form.appendChild(methodInput);
    }
    
    // Change button text
    form.querySelector('button[type="submit"]').textContent = <?php echo json_encode(__('admin.wallets.update_wallet'), 15, 512) ?>;
    
    // Scroll to form
    form.scrollIntoView({ behavior: 'smooth', block: 'start' });
}

function previewQRCode(input) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('qr_preview_img').src = e.target.result;
            document.getElementById('qr_preview').style.display = 'block';
            document.getElementById('existing_qr_preview').innerHTML = '';
        };
        reader.readAsDataURL(input.files[0]);
    }
}

function clearQRPreview() {
    document.getElementById('wallet_qr_code').value = '';
    document.getElementById('qr_preview').style.display = 'none';
    document.getElementById('qr_preview_img').src = '';
}

function showQRCodeModal(qrCodeUrl, address, network) {
    document.getElementById('qrModalTitle').textContent = network.toUpperCase() + ' QR Code';
    document.getElementById('qrNetwork').textContent = network.toUpperCase();
    document.getElementById('qrAddress').textContent = address;
    
    // Show uploaded QR code image instead of generating
    const qrContainer = document.getElementById('qrCodeContainer');
    qrContainer.innerHTML = `<img src="${qrCodeUrl}" alt="QR Code" style="max-width: 256px; max-height: 256px;">`;
    
    document.getElementById('qrModal').style.display = 'flex';
    currentQRData = { address, network };
}

// Reset form for new wallet
document.getElementById('walletForm').addEventListener('reset', function() {
    this.action = '<?php echo e(route("admin.wallets.store")); ?>';
    const methodInput = this.querySelector('input[name="_method"]');
    if (methodInput) {
        methodInput.remove();
    }
    this.querySelector('button[type="submit"]').textContent = <?php echo json_encode(__('admin.wallets.save_wallet'), 15, 512) ?>;
    document.getElementById('existing_qr_preview').innerHTML = '';
    document.getElementById('qr_preview').style.display = 'none';
});
</script>

<style>
.modal-backdrop {
    position: fixed;
    inset: 0;
    background: rgba(10, 14, 39, 0.9);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
    padding: 20px;
}

.modal-card {
    background: var(--card);
    border-radius: 20px;
    padding: 24px;
    max-width: 500px;
    width: 100%;
    box-shadow: var(--shadow);
    position: relative;
}

.modal-header {
    margin-bottom: 16px;
    position: relative;
}

.modal-title {
    font-size: 20px;
    font-weight: 600;
    margin: 0;
}

.modal-body {
    padding: 0;
}
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/wallets/index.blade.php ENDPATH**/ ?>