

<?php $__env->startSection('content'); ?>
<div class="grid-2">
    <div class="panel-card">
        <div class="panel-header">
            <h2>Bot Information</h2>
        </div>
        <div class="panel-body">
            <div class="info-row">
                <span class="label">Name:</span>
                <span class="value"><?php echo e($bot->name); ?></span>
            </div>
            <div class="info-row">
                <span class="label">Trading Pair:</span>
                <span class="value"><?php echo e($bot->trading_pair); ?></span>
            </div>
            <div class="info-row">
                <span class="label">Leverage:</span>
                <span class="value"><?php echo e($bot->leverage); ?>x</span>
            </div>
            <div class="info-row">
                <span class="label">Amount:</span>
                <span class="value">$<?php echo e(number_format($bot->amount, 2)); ?></span>
            </div>
            <div class="info-row">
                <span class="label">Status:</span>
                <span class="value">
                    <span class="badge badge-<?php echo e($bot->status === 'active' ? 'success' : ($bot->status === 'stopped' ? 'danger' : 'warning')); ?>">
                        <?php echo e(ucfirst($bot->status)); ?>

                    </span>
                </span>
            </div>
            <?php if($bot->status === 'active' && $bot->admin_activated_at): ?>
            <div class="info-row" style="background: rgba(34, 197, 94, 0.1); padding: 8px 12px; border-radius: 6px; margin: 8px 0;">
                <span class="label" style="font-weight: 600;">Started at:</span>
                <span class="value" style="color: #22c55e;"><?php echo e($bot->admin_activated_at->format('Y-m-d H:i:s')); ?> (Bot is running)</span>
            </div>
            <?php endif; ?>
            <?php
                $profit = isset($livePl) && $livePl ? $livePl['totalProfit'] : (float)$bot->total_profit;
                $loss = isset($livePl) && $livePl ? $livePl['totalLoss'] : (float)$bot->total_loss;
                $netPl = $profit - $loss;
            ?>
            <div class="info-row">
                <span class="label">Total Profit:</span>
                <span class="value" style="color: #26a69a;">$<?php echo e(number_format($profit, 2)); ?><?php echo e(isset($livePl) && $livePl ? ' <small style="opacity:0.8">(live)</small>' : ''); ?></span>
            </div>
            <div class="info-row">
                <span class="label">Total Loss:</span>
                <span class="value" style="color: #ef5350;">$<?php echo e(number_format($loss, 2)); ?></span>
            </div>
            <div class="info-row">
                <span class="label">Net P/L:</span>
                <span class="value" style="color: <?php echo e($netPl >= 0 ? '#26a69a' : '#ef5350'); ?>;">
                    $<?php echo e(number_format($netPl, 2)); ?>

                </span>
            </div>
            <?php if($bot->closed_at): ?>
            <div class="info-row">
                <span class="label">Closed At:</span>
                <span class="value"><?php echo e($bot->closed_at->format('Y-m-d H:i:s')); ?></span>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="panel-card">
        <div class="panel-header">
            <h2>Control Bot</h2>
        </div>
        <div class="panel-body">
            <form method="POST" action="<?php echo e(route('admin.ai-trade.update', $bot->id)); ?>" id="control-bot-form">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <div class="form-group">
                    <label>Status</label>
                    <select name="status" class="form-control">
                        <option value="active" <?php echo e($bot->status === 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="paused" <?php echo e($bot->status === 'paused' ? 'selected' : ''); ?>>Paused</option>
                        <option value="stopped" <?php echo e($bot->status === 'stopped' ? 'selected' : ''); ?>>Stopped</option>
                        <option value="closed" <?php echo e($bot->status === 'closed' ? 'selected' : ''); ?>>Closed</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Max Profit %</label>
                    <input type="number" name="max_profit_percent" id="max_profit_percent" value="<?php echo e($bot->max_profit_percent); ?>" step="0.01" min="0" max="100" class="form-control">
                </div>

                <div class="form-group">
                    <label>Max Loss %</label>
                    <input type="number" name="max_loss_percent" id="max_loss_percent" value="<?php echo e($bot->max_loss_percent); ?>" step="0.01" min="0" max="100" class="form-control">
                </div>

                <div class="form-group">
                    <label>Trade time (minutes)</label>
                    <input type="number" name="admin_set_trading_time_minutes" value="<?php echo e(old('admin_set_trading_time_minutes', $bot->admin_set_trading_time_minutes ?? 1440)); ?>" min="1" max="1440" class="form-control" placeholder="1440 = 24 hours">
                    <small style="color: #999; font-size: 12px;">Per-user trade duration. 1440 = 24 hours. When reached, bot closes and final P/L uses Win/Loss % above.</small>
                </div>

                <div class="form-group">
                    <label>Total Profit (Override)</label>
                    <input type="number" name="total_profit" value="<?php echo e($bot->total_profit); ?>" step="0.01" class="form-control">
                    <small style="color: #999; font-size: 12px;">Optional: Override total profit value</small>
                </div>

                <div class="form-group">
                    <label>Total Loss (Override)</label>
                    <input type="number" name="total_loss" value="<?php echo e($bot->total_loss); ?>" step="0.01" class="form-control">
                    <small style="color: #999; font-size: 12px;">Optional: Override total loss value</small>
                </div>

                <button type="submit" class="btn btn-primary">Update Bot</button>
            </form>

        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quanruqw/public_html/backend/resources/views/admin/ai-trade/show.blade.php ENDPATH**/ ?>