<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\WalletController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\DepositController;
use App\Http\Controllers\Api\WithdrawalController;
use App\Http\Controllers\Api\AiTradeController;
use App\Http\Controllers\Api\MarketController;
use App\Http\Controllers\Api\BalanceController;
use App\Http\Controllers\Api\MarketPriceController;
use App\Http\Controllers\Api\SwapController;
use App\Http\Controllers\Api\EarningsController;
use App\Http\Controllers\Api\SettingsController;

// Public routes
Route::post('/wallet/connect', [WalletController::class, 'connect']);
Route::post('/wallet/disconnect', [WalletController::class, 'disconnect']);
Route::get('/deposits/addresses', [DepositController::class, 'addresses']); // Public - no auth required

// Protected routes (wallet authenticated)
Route::middleware('wallet.auth')->group(function () {
    // User data
    Route::get('/user', [UserController::class, 'profile']);
    Route::get('/user/stats', [UserController::class, 'stats']);
    
    // Balances
    Route::get('/balances', [BalanceController::class, 'index']);
    
    // Deposits
    Route::get('/deposits', [DepositController::class, 'index']);
    Route::get('/deposits/{id}', [DepositController::class, 'show']);
    Route::post('/deposits', [DepositController::class, 'store']);
    
    // Withdrawals
    Route::get('/withdrawals', [WithdrawalController::class, 'index']);
    Route::post('/withdrawals', [WithdrawalController::class, 'store']);
    
    // Swaps
    Route::get('/swaps', [SwapController::class, 'index']);
    Route::post('/swaps', [SwapController::class, 'store']);
    
    // AI Trade
    Route::get('/ai-trade/bots', [AiTradeController::class, 'index']);
    Route::post('/ai-trade/bots', [AiTradeController::class, 'store']);
    Route::put('/ai-trade/bots/{id}', [AiTradeController::class, 'update']);
    Route::delete('/ai-trade/bots/{id}', [AiTradeController::class, 'destroy']);
    Route::post('/ai-trade/bots/{id}/toggle', [AiTradeController::class, 'toggle']);
    Route::post('/ai-trade/bots/{id}/stop', [AiTradeController::class, 'stop']);
    Route::post('/ai-trade/bots/{id}/close', [AiTradeController::class, 'close']);
    Route::get('/ai-trade/stats', [AiTradeController::class, 'stats']);
    
    // Orders
    Route::get('/orders', [AiTradeController::class, 'orders']);
    
    // Earnings
    Route::get('/earnings/today', [EarningsController::class, 'today']);
    Route::get('/earnings/history', [EarningsController::class, 'history']);
    
    // Referrals
    Route::get('/referrals', [UserController::class, 'referrals']);
    Route::get('/referrals/stats', [UserController::class, 'referralStats']);
    
    // Support/Customer Service
    Route::get('/support/messages', [\App\Http\Controllers\Api\SupportController::class, 'getMessages']);
    Route::post('/support/messages', [\App\Http\Controllers\Api\SupportController::class, 'sendMessage']);
    Route::get('/support/unread-count', [\App\Http\Controllers\Api\SupportController::class, 'getUnreadCount']);

    // Settings - Withdrawal PIN (confirm withdrawals)
    Route::post('/settings/pin', [SettingsController::class, 'setPin']);

    // Notifications (list, unread count, mark read)
    Route::get('/notifications', [\App\Http\Controllers\Api\NotificationController::class, 'index']);
    Route::get('/notifications/unread-count', [\App\Http\Controllers\Api\NotificationController::class, 'unreadCount']);
    Route::post('/notifications/mark-all-read', [\App\Http\Controllers\Api\NotificationController::class, 'markAllRead']);
    Route::post('/notifications/{id}/mark-read', [\App\Http\Controllers\Api\NotificationController::class, 'markRead']);

    // Discover (feed, post, like, comments)
    Route::get('/discover/posts', [\App\Http\Controllers\Api\DiscoverController::class, 'index']);
    Route::post('/discover/posts', [\App\Http\Controllers\Api\DiscoverController::class, 'store']);
    Route::post('/discover/posts/{id}/like', [\App\Http\Controllers\Api\DiscoverController::class, 'toggleLike']);
    Route::get('/discover/posts/{id}/comments', [\App\Http\Controllers\Api\DiscoverController::class, 'comments']);
    Route::post('/discover/posts/{id}/comments', [\App\Http\Controllers\Api\DiscoverController::class, 'storeComment']);
});

// Markets (public)
Route::get('/markets', [MarketController::class, 'index']);
Route::get('/markets/{pair}', [MarketController::class, 'show']);

// Market Prices (public - real-time from Binance)
Route::get('/market-prices/top', [MarketPriceController::class, 'topMarkets']);
Route::get('/market-prices/coin/{coin}', [MarketPriceController::class, 'getCoinPrice']);
Route::get('/market-prices/coins', [MarketPriceController::class, 'getCoinPrices']);

// Chart data endpoints
Route::get('/chart/klines', [\App\Http\Controllers\Api\ChartController::class, 'getKlines']);
Route::get('/chart/pairs', [\App\Http\Controllers\Api\ChartController::class, 'getTradingPairs']);

// Announcements (list + comments public; like requires auth)
Route::get('/announcements', [\App\Http\Controllers\Api\AnnouncementController::class, 'index']);
Route::get('/announcements/{id}/comments', [\App\Http\Controllers\Api\AnnouncementController::class, 'comments']);
Route::post('/announcements/{id}/like', [\App\Http\Controllers\Api\AnnouncementController::class, 'toggleLike'])->middleware('wallet.auth');
