@extends('admin.layout')

@section('content')
<div class="panel-card">
    <div class="panel-header">
        <h2>{{ __('admin.withdrawals.title') }}</h2>
        <form method="GET" action="{{ route('admin.withdrawals') }}" class="search-form">
            <select name="status">
                <option value="">{{ __('admin.users.all_status') }}</option>
                <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>{{ __('admin.deposits.pending') }}</option>
                <option value="processing" {{ request('status') === 'processing' ? 'selected' : '' }}>{{ __('admin.withdrawals.processing') }}</option>
                <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>{{ __('admin.withdrawals.completed') }}</option>
                <option value="rejected" {{ request('status') === 'rejected' ? 'selected' : '' }}>{{ __('admin.withdrawals.rejected') }}</option>
            </select>
            <button type="submit">{{ __('admin.withdrawals.filter') }}</button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>{{ __('admin.table.id') }}</th>
                    <th>{{ __('admin.withdrawals.user') }}</th>
                    <th>{{ __('admin.withdrawals.coin') }}</th>
                    <th>{{ __('admin.withdrawals.network') }}</th>
                    <th>{{ __('admin.withdrawals.address') }}</th>
                    <th>{{ __('admin.withdrawals.amount') }}</th>
                    <th>{{ __('admin.withdrawals.status') }}</th>
                    <th>{{ __('admin.withdrawals.date') }}</th>
                    <th>{{ __('admin.table.actions') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($withdrawals as $withdrawal)
                <tr>
                    <td>{{ str_pad($withdrawal->user->id, 6, '0', STR_PAD_LEFT) }}</td>
                    <td>{{ substr($withdrawal->user->wallet_address ?? 'N/A', 0, 10) }}...</td>
                    <td><strong>{{ $withdrawal->coin_name }}</strong></td>
                    <td><span class="badge badge-info">{{ $withdrawal->network }}</span></td>
                    <td class="withdraw-address-cell">
                        <span class="withdraw-address-text" title="{{ $withdrawal->address }}">{{ $withdrawal->address }}</span>
                        <button type="button" class="btn btn-sm btn-outline copy-address-btn" data-address="{{ e($withdrawal->address) }}" title="{{ __('admin.withdrawals.copy_address') }}">Copy</button>
                    </td>
                    <td>${{ number_format($withdrawal->amount, 2) }}</td>
                    <td>
                        <span class="badge badge-{{ $withdrawal->status === 'completed' ? 'success' : ($withdrawal->status === 'rejected' ? 'danger' : 'warning') }}">
                            {{ __('admin.withdrawals.' . $withdrawal->status) }}
                        </span>
                    </td>
                    <td>{{ $withdrawal->created_at->format('Y-m-d H:i') }}</td>
                    <td>
                        @if(in_array($withdrawal->status, ['pending', 'processing']))
                        <form method="POST" action="{{ route('admin.withdrawals.update', $withdrawal->id) }}" style="display:inline;">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="status" value="completed">
                            <button type="submit" class="btn btn-sm btn-success">{{ __('admin.withdrawals.complete') }}</button>
                        </form>
                        <form method="POST" action="{{ route('admin.withdrawals.update', $withdrawal->id) }}" style="display:inline;">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="status" value="rejected">
                            <textarea name="reason" placeholder="{{ __('admin.withdrawals.reason') }}" required class="form-control-sm"></textarea>
                            <button type="submit" class="btn btn-sm btn-danger">{{ __('admin.withdrawals.reject') }}</button>
                        </form>
                        @else
                        <span class="text-muted">{{ __('admin.withdrawals.processed') }}</span>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="9" class="text-center">{{ __('admin.withdrawals.no_found') }}</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @include('admin.partials.pagination', ['items' => $withdrawals])
</div>

<style>
.withdraw-address-cell {
    max-width: 280px;
    vertical-align: middle;
}
.withdraw-address-text {
    display: inline-block;
    word-break: break-all;
    font-size: 12px;
    margin-right: 8px;
    vertical-align: middle;
}
.withdraw-address-cell .copy-address-btn {
    white-space: nowrap;
    flex-shrink: 0;
}
</style>
<script>
(function() {
    document.querySelectorAll('.copy-address-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            var address = this.getAttribute('data-address');
            if (!address) return;
            if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(address).then(function() {
                    var t = btn.textContent;
                    btn.textContent = 'Copied!';
                    setTimeout(function() { btn.textContent = t; }, 1500);
                }).catch(function() {
                    fallbackCopy(address, btn);
                });
            } else {
                fallbackCopy(address, btn);
            }
        });
    });
    function fallbackCopy(text, btn) {
        var ta = document.createElement('textarea');
        ta.value = text;
        ta.style.position = 'fixed';
        ta.style.left = '-9999px';
        document.body.appendChild(ta);
        ta.select();
        try {
            document.execCommand('copy');
            var t = btn.textContent;
            btn.textContent = 'Copied!';
            setTimeout(function() { btn.textContent = t; }, 1500);
        } catch (e) {}
        document.body.removeChild(ta);
    }
})();
</script>
@endsection

