@extends('admin.layout')

@section('content')
@php
    use Illuminate\Support\Str;
@endphp
<div class="panel-card">
    <div class="panel-header">
        <h2>Customer Service Management</h2>
        <form class="search-form" method="GET" action="{{ route('admin.support') }}">
            <input type="text" name="search" placeholder="Search by wallet or email" value="{{ request('search') }}" class="form-control">
            <select name="status" class="form-control">
                <option value="">All Status</option>
                <option value="open" {{ request('status') == 'open' ? 'selected' : '' }}>Open</option>
                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                <option value="resolved" {{ request('status') == 'resolved' ? 'selected' : '' }}>Resolved</option>
                <option value="closed" {{ request('status') == 'closed' ? 'selected' : '' }}>Closed</option>
            </select>
            <button type="submit" class="btn btn-primary">Filter</button>
            @if(request()->has('search') || request()->has('status'))
                <a href="{{ route('admin.support') }}" class="btn btn-outline">Clear</a>
            @endif
        </form>
    </div>
    <div class="panel-body">
        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Last Message</th>
                        <th>Status</th>
                        <th>Priority</th>
                        <th>Last Activity</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($tickets as $ticket)
                        <tr>
                            <td>#{{ $ticket->id }}</td>
                            <td>
                                <div>
                                    <strong>{{ $ticket->user->wallet_address ?? 'N/A' }}</strong><br>
                                    <small class="text-muted">{{ $ticket->user->email ?? 'N/A' }}</small>
                                </div>
                            </td>
                            <td>
                                @php
                                    $latestMessage = $ticket->messages()->latest()->first();
                                @endphp
                                @if($latestMessage)
                                    <div class="text-truncate" style="max-width: 200px;">
                                        {{ Str::limit($latestMessage->message ?? 'Image attachment', 50) }}
                                    </div>
                                @else
                                    <span class="text-muted">No messages</span>
                                @endif
                            </td>
                            <td>
                                <span class="badge badge-{{ $ticket->status }}">
                                    {{ ucfirst($ticket->status) }}
                                </span>
                            </td>
                            <td>
                                <span class="badge badge-{{ $ticket->priority }}">
                                    {{ ucfirst($ticket->priority) }}
                                </span>
                            </td>
                            <td>
                                {{ $ticket->last_message_at ? $ticket->last_message_at->diffForHumans() : $ticket->created_at->diffForHumans() }}
                            </td>
                            <td>
                                <a href="{{ route('admin.support.show', $ticket->id) }}" class="btn btn-sm btn-primary">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted">No support tickets found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @include('admin.partials.pagination', ['items' => $tickets])
    </div>
</div>
@endsection
