@extends('admin.layout')

@section('content')
<div class="panel-card">
    <div class="panel-header">
        <h2>{{ __('admin.referrals.title') }}</h2>
        <form method="GET" action="{{ route('admin.referrals') }}" class="search-form">
            <input type="number" name="user_id" placeholder="{{ __('admin.referrals.user_id_placeholder') }}" value="{{ request('user_id') }}">
            <button type="submit">{{ __('admin.referrals.filter') }}</button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>{{ __('admin.table.id') }}</th>
                    <th>{{ __('admin.referrals.referrer') }}</th>
                    <th>{{ __('admin.referrals.referred_user') }}</th>
                    <th>{{ __('admin.referrals.level') }}</th>
                    <th>{{ __('admin.referrals.total_earnings') }}</th>
                    <th>{{ __('admin.referrals.date') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($referrals as $referral)
                <tr>
                    <td>{{ $referral->id }}</td>
                    <td>{{ substr($referral->user->wallet_address ?? 'N/A', 0, 10) }}...</td>
                    <td>{{ substr($referral->referredUser->wallet_address ?? 'N/A', 0, 10) }}...</td>
                    <td>{{ $referral->level }}</td>
                    <td>${{ number_format($referral->total_earnings, 2) }}</td>
                    <td>{{ $referral->created_at->format('Y-m-d') }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="text-center">{{ __('admin.referrals.no_found') }}</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @include('admin.partials.pagination', ['items' => $referrals])
</div>
@endsection

