<header class="admin-topbar">
    <button type="button" class="admin-menu-toggle" id="adminSidebarToggle" aria-label="Menu" title="Menu">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
    </button>
    <div class="topbar-title">
        <h1>{{ $pageTitle ?? __('admin.nav.dashboard') }}</h1>
        <p class="topbar-subtitle">{{ __('admin.subtitle') }}</p>
    </div>
    <div class="topbar-actions" style="display: flex; align-items: center; gap: 12px; flex-wrap: wrap;">
        <div class="topbar-lang" style="position: relative;">
            <form method="post" action="{{ route('admin.set-locale') }}" id="admin-lang-form">
                @csrf
                <input type="hidden" name="locale" id="admin-lang-input" value="{{ app()->getLocale() }}">
                <button type="button" class="btn btn-outline" id="admin-lang-btn" style="min-width: 100px; text-align: left; display: inline-flex; align-items: center; justify-content: space-between; gap: 6px;" aria-haspopup="listbox" aria-expanded="false" aria-label="{{ __('admin.language') }}">
                    <span id="admin-lang-label">{{ app()->getLocale() === 'zh' ? __('admin.chinese') : __('admin.english') }}</span>
                    <span aria-hidden="true" style="font-size: 10px;">▼</span>
                </button>
            </form>
            <div id="admin-lang-dropdown" style="display: none; position: absolute; top: 100%; right: 0; margin-top: 4px; background: var(--card); border: 1px solid var(--border); border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.15); z-index: 1000; min-width: 100px;">
                <button type="button" class="admin-lang-option" data-locale="en" style="display: block; width: 100%; padding: 10px 14px; text-align: left; border: none; background: none; cursor: pointer; color: var(--text); font-size: 14px; border-radius: 6px;">English</button>
                <button type="button" class="admin-lang-option" data-locale="zh" style="display: block; width: 100%; padding: 10px 14px; text-align: left; border: none; background: none; cursor: pointer; color: var(--text); font-size: 14px; border-radius: 6px;">中文</button>
            </div>
        </div>
        <div class="topbar-issue" style="position: relative;">
            <button type="button" class="btn btn-outline" id="admin-issue-btn" style="min-width: 120px; display: inline-flex; align-items: center; justify-content: space-between; gap: 6px;" aria-haspopup="true" aria-expanded="false">
                <span>{{ __('admin.have_an_issue') }}</span>
                <span aria-hidden="true" style="font-size: 10px;">▼</span>
            </button>
            <div id="admin-issue-dropdown" style="display: none; position: absolute; top: 100%; right: 0; margin-top: 4px; background: var(--card); border: 1px solid var(--border); border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.15); z-index: 1000; min-width: 220px; padding: 12px 14px; white-space: nowrap;">
                <span style="color: var(--muted); font-size: 12px;">contact:</span>
                <span style="color: var(--primary); font-weight: 600; font-size: 14px;">@jor111codingservices</span>
            </div>
        </div>
        <form method="post" action="{{ route('admin.logout') }}">
            @csrf
            <button class="btn btn-outline" type="submit">{{ __('admin.logout') }}</button>
        </form>
    </div>
</header>
<script>
(function() {
    var btn = document.getElementById('admin-lang-btn');
    var dropdown = document.getElementById('admin-lang-dropdown');
    var input = document.getElementById('admin-lang-input');
    var form = document.getElementById('admin-lang-form');
    var label = document.getElementById('admin-lang-label');
    if (!btn || !dropdown) return;
    var langJustOpened = false;
    btn.addEventListener('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        var open = dropdown.style.display !== 'block';
        dropdown.style.display = open ? 'block' : 'none';
        if (open) langJustOpened = true;
    });
    dropdown.addEventListener('click', function(e) { e.stopPropagation(); });
    document.querySelectorAll('.admin-lang-option').forEach(function(opt) {
        opt.addEventListener('click', function(e) {
            e.stopPropagation();
            input.value = this.getAttribute('data-locale');
            form.submit();
        });
    });
    document.addEventListener('click', function() {
        if (langJustOpened) {
            langJustOpened = false;
            return;
        }
        dropdown.style.display = 'none';
        var issueDrop = document.getElementById('admin-issue-dropdown');
        if (issueDrop) issueDrop.style.display = 'none';
    });
    document.addEventListener('touchend', function(e) {
        if (langJustOpened && e.target !== btn && !dropdown.contains(e.target)) {
            langJustOpened = false;
        }
    }, true);
})();
(function() {
    var issueBtn = document.getElementById('admin-issue-btn');
    var issueDropdown = document.getElementById('admin-issue-dropdown');
    if (!issueBtn || !issueDropdown) return;
    issueBtn.addEventListener('click', function(e) {
        e.stopPropagation();
        var langDrop = document.getElementById('admin-lang-dropdown');
        if (langDrop) langDrop.style.display = 'none';
        issueDropdown.style.display = issueDropdown.style.display === 'none' ? 'block' : 'none';
    });
    issueDropdown.addEventListener('click', function(e) { e.stopPropagation(); });
})();
</script>

