@if(isset($items))
@php
    $hasPages = method_exists($items, 'hasPages') ? $items->hasPages() : false;
    $total = method_exists($items, 'total') ? $items->total() : 0;
    $currentPage = method_exists($items, 'currentPage') ? $items->currentPage() : 1;
    $lastPage = method_exists($items, 'lastPage') ? $items->lastPage() : 1;
    $onFirstPage = method_exists($items, 'onFirstPage') ? $items->onFirstPage() : true;
    $hasMorePages = method_exists($items, 'hasMorePages') ? $items->hasMorePages() : false;
@endphp
@if($hasPages || $total > 0)
<div class="admin-pagination">
    <div class="pagination-info">
        <span class="pagination-total">{{ __('admin.pagination.total') }} {{ $total }}</span>
        
        <select class="pagination-per-page" onchange="changePerPage(this.value)">
            <option value="10" {{ request('per_page', 10) == 10 ? 'selected' : '' }}>{{ __('admin.pagination.per_page', ['count' => 10]) }}</option>
            <option value="20" {{ request('per_page', 10) == 20 ? 'selected' : '' }}>{{ __('admin.pagination.per_page', ['count' => 20]) }}</option>
            <option value="50" {{ request('per_page', 10) == 50 ? 'selected' : '' }}>{{ __('admin.pagination.per_page', ['count' => 50]) }}</option>
            <option value="100" {{ request('per_page', 10) == 100 ? 'selected' : '' }}>{{ __('admin.pagination.per_page', ['count' => 100]) }}</option>
        </select>
    </div>

    <div class="pagination-controls">
        <!-- Previous Button -->
        <button 
            class="pagination-btn {{ $onFirstPage ? 'disabled' : '' }}"
            onclick="goToPage({{ $currentPage - 1 }})"
            {{ $onFirstPage ? 'disabled' : '' }}
        >
            ‹
        </button>

        <!-- Page Numbers -->
        @php
            $startPage = max(1, $currentPage - 2);
            $endPage = min($lastPage, $currentPage + 2);
            
            // Show first page if not in range
            if ($startPage > 1) {
                $showFirst = true;
            } else {
                $showFirst = false;
            }
            
            // Show last page if not in range
            if ($endPage < $lastPage) {
                $showLast = true;
            } else {
                $showLast = false;
            }
        @endphp

        @if($showFirst)
            <button class="pagination-btn" onclick="goToPage(1)">1</button>
            @if($startPage > 2)
                <span class="pagination-ellipsis">...</span>
            @endif
        @endif

        @for($page = $startPage; $page <= $endPage; $page++)
            <button 
                class="pagination-btn {{ $page == $currentPage ? 'active' : '' }}"
                onclick="goToPage({{ $page }})"
            >
                {{ $page }}
            </button>
        @endfor

        @if($showLast)
            @if($endPage < $lastPage - 1)
                <span class="pagination-ellipsis">...</span>
            @endif
            <button class="pagination-btn" onclick="goToPage({{ $lastPage }})">{{ $lastPage }}</button>
        @endif

        <!-- Next Button -->
        <button 
            class="pagination-btn {{ $hasMorePages ? '' : 'disabled' }}"
            onclick="goToPage({{ $currentPage + 1 }})"
            {{ $hasMorePages ? '' : 'disabled' }}
        >
            ›
        </button>
    </div>

    <div class="pagination-goto">
        <span>{{ __('admin.pagination.go_to') }}</span>
        <input 
            type="number" 
            class="pagination-goto-input" 
            min="1" 
            max="{{ $lastPage }}" 
            value="{{ $currentPage }}"
            onkeypress="if(event.key === 'Enter') { goToPage(this.value); }"
        >
    </div>
</div>

<script>
function goToPage(page) {
    if (page < 1 || page > {{ $lastPage }}) return;
    
    const url = new URL(window.location.href);
    url.searchParams.set('page', page);
    
    // Preserve other query parameters
    @foreach(request()->except('page', 'per_page') as $key => $value)
        url.searchParams.set('{{ $key }}', '{{ $value }}');
    @endforeach
    
    // Preserve per_page if set
    const perPage = url.searchParams.get('per_page') || '{{ request('per_page', 10) }}';
    if (perPage) {
        url.searchParams.set('per_page', perPage);
    }
    
    window.location.href = url.toString();
}

function changePerPage(perPage) {
    const url = new URL(window.location.href);
    url.searchParams.set('per_page', perPage);
    url.searchParams.set('page', '1'); // Reset to first page
    
    // Preserve other query parameters
    @foreach(request()->except('page', 'per_page') as $key => $value)
        url.searchParams.set('{{ $key }}', '{{ $value }}');
    @endforeach
    
    window.location.href = url.toString();
}
</script>
@endif
@endif

