@extends('admin.layout')

@section('content')
<div class="panel-card">
    <div class="panel-header">
        <h2>Order Information</h2>
    </div>
    <div class="panel-body">
        <div class="info-row">
            <span class="label">User:</span>
            <span class="value">{{ $order->user->wallet_address ?? 'N/A' }}</span>
        </div>
        <div class="info-row">
            <span class="label">Bot:</span>
            <span class="value">{{ $order->aiTradeBot->name ?? 'N/A' }}</span>
        </div>
        <div class="info-row">
            <span class="label">Type:</span>
            <span class="value">{{ ucfirst($order->order_type) }}</span>
        </div>
        <div class="info-row">
            <span class="label">Amount:</span>
            <span class="value">${{ number_format($order->amount, 2) }}</span>
        </div>
        <div class="info-row">
            <span class="label">Status:</span>
            <span class="value">
                <span class="badge badge-{{ $order->status === 'completed' ? 'success' : ($order->status === 'cancelled' ? 'danger' : 'warning') }}">
                    {{ ucfirst($order->status) }}
                </span>
            </span>
        </div>
        <div class="info-row">
            <span class="label">Profit/Loss:</span>
            <span class="value" style="color: {{ $order->profit_loss >= 0 ? '#26a69a' : '#ef5350' }};">
                ${{ number_format($order->profit_loss, 2) }}
            </span>
        </div>
        @if($order->admin_adjusted_profit_loss !== null)
        <div class="info-row">
            <span class="label">Admin Adjusted P/L:</span>
            <span class="value" style="color: {{ $order->admin_adjusted_profit_loss >= 0 ? '#26a69a' : '#ef5350' }};">
                ${{ number_format($order->admin_adjusted_profit_loss, 2) }}
            </span>
        </div>
        <div class="info-row">
            <span class="label">Adjustment Reason:</span>
            <span class="value">{{ $order->admin_adjustment_reason }}</span>
        </div>
        <div class="info-row">
            <span class="label">Adjusted At:</span>
            <span class="value">{{ $order->admin_adjusted_at ? $order->admin_adjusted_at->format('Y-m-d H:i:s') : 'N/A' }}</span>
        </div>
        @endif
        <div class="info-row">
            <span class="label">Executed At:</span>
            <span class="value">{{ $order->executed_at ? $order->executed_at->format('Y-m-d H:i:s') : 'N/A' }}</span>
        </div>
        @if($order->admin_adjusted_executed_at)
        <div class="info-row">
            <span class="label">Admin Adjusted Executed At:</span>
            <span class="value">{{ $order->admin_adjusted_executed_at->format('Y-m-d H:i:s') }}</span>
        </div>
        @endif
        <div class="info-row">
            <span class="label">Created:</span>
            <span class="value">{{ $order->created_at->format('Y-m-d H:i:s') }}</span>
        </div>
    </div>
</div>

<div class="panel-card" style="margin-top: 20px; padding: 15px; background: var(--card-bg, #2d3748); border: 1px solid var(--border-color, #4a5568); border-radius: 4px;">
    <div style="color: #fff; font-weight: 600; margin-bottom: 10px;">ℹ️ Information</div>
    <div style="color: #a0aec0; font-size: 13px; line-height: 1.6;">
        <strong>Note:</strong> This page is for viewing order details only. To adjust profit/loss or trade time for orders, please use the <strong>AI Trade Management</strong> page where the bot controls are available.
    </div>
</div>
@endsection

