@extends('admin.layout')

@section('content')
<div class="panel-card">
    <div class="panel-header">
        <h2>Orders</h2>
        <form method="GET" action="{{ route('admin.orders') }}" class="search-form">
            <select name="status">
                <option value="">All Status</option>
                <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                <option value="processing" {{ request('status') === 'processing' ? 'selected' : '' }}>Processing</option>
                <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>Completed</option>
                <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
            </select>
            <button type="submit">Filter</button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User ID</th>
                    <th>Bot</th>
                    <th>Trading Pair</th>
                    <th>Side</th>
                    <th>Amount</th>
                    <th>Profit/Loss</th>
                    <th>Status</th>
                    <th>Executed At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($orders as $order)
                <tr>
                    <td>{{ $order->id }}</td>
                    <td>{{ str_pad($order->user->id, 6, '0', STR_PAD_LEFT) }}</td>
                    <td>{{ $order->aiTradeBot->name ?? 'N/A' }}</td>
                    <td>{{ $order->trading_pair }}</td>
                    <td>
                        <span style="color: {{ $order->side === 'buy' ? '#26a69a' : '#ef5350' }};">
                            {{ strtoupper($order->side) }}
                        </span>
                    </td>
                    <td>${{ number_format($order->amount, 2) }}</td>
                    <td style="color: {{ ($order->admin_adjusted_profit_loss ?? $order->profit_loss) >= 0 ? '#26a69a' : '#ef5350' }};">
                        ${{ number_format($order->admin_adjusted_profit_loss ?? $order->profit_loss, 2) }}
                        @if($order->admin_adjusted_profit_loss !== null)
                            <small style="display: block; color: #8B8FA3; font-size: 11px;">(Adjusted)</small>
                        @endif
                    </td>
                    <td>
                        <span class="badge badge-{{ $order->status === 'filled' ? 'success' : ($order->status === 'cancelled' || $order->status === 'failed' ? 'danger' : 'warning') }}">
                            {{ ucfirst($order->status) }}
                        </span>
                    </td>
                    <td>{{ $order->executed_at ? $order->executed_at->format('Y-m-d H:i') : 'N/A' }}</td>
                    <td>
                        <a href="{{ route('admin.orders.show', $order->id) }}" class="btn btn-sm btn-primary">View</a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="10" class="text-center">No orders found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @include('admin.partials.pagination', ['items' => $orders])
</div>
@endsection

