@extends('admin.layout')

@section('content')
@if(session('success'))
<div class="alert alert-success" style="background: var(--primary-soft); color: var(--primary); padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid var(--primary);">
    {{ session('success') }}
</div>
@endif

<div class="grid-2">
    <div class="panel-card">
        <div class="panel-header">
            <h2>{{ __('admin.notifications.send_title') }}</h2>
            <form method="GET" action="{{ route('admin.notifications') }}" class="search-form">
                <input type="text" name="search" placeholder="{{ __('admin.notifications.search_placeholder') }}" value="{{ request('search') }}">
                <button type="submit">{{ __('admin.notifications.search') }}</button>
            </form>
        </div>
        <div class="panel-body">
            <form method="POST" action="{{ route('admin.notifications.send') }}" id="sendNotiForm">
                @csrf
                <div class="form-group">
                    <label>{{ __('admin.notifications.message_type') }}</label>
                    <select name="message_type" class="form-control" required>
                        <option value="maintenance">{{ __('admin.notifications.maintenance') }}</option>
                        <option value="success">{{ __('admin.notifications.success') }}</option>
                        <option value="info">{{ __('admin.notifications.info') }}</option>
                        <option value="custom">{{ __('admin.notifications.custom') }}</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>{{ __('admin.notifications.title_label') }}</label>
                    <input type="text" name="title" class="form-control" maxlength="255" required placeholder="{{ __('admin.notifications.title_placeholder') }}">
                </div>
                <div class="form-group">
                    <label>{{ __('admin.notifications.message_label') }}</label>
                    <textarea name="message" class="form-control" rows="4" maxlength="5000" required placeholder="{{ __('admin.notifications.message_placeholder') }}"></textarea>
                </div>
                <div class="form-group">
                    <label>{{ __('admin.notifications.select_users') }}</label>
                    <div style="max-height: 320px; overflow-y: auto; border: 1px solid var(--border); border-radius: 8px; padding: 12px;">
                        <label style="display: block; margin-bottom: 8px;"><input type="checkbox" id="selectAllUsers"> {{ __('admin.notifications.select_all_page') }}</label>
                        @forelse($users as $user)
                        <label style="display: flex; align-items: center; gap: 8px; padding: 6px 0;">
                            <input type="checkbox" name="user_ids[]" value="{{ $user->id }}" class="user-checkbox">
                            <span>#{{ $user->id }} {{ Str::limit($user->wallet_address, 12) }} ({{ Str::limit($user->name, 15) }})</span>
                        </label>
                        @empty
                        <p class="text-muted">{{ __('admin.notifications.no_users_found') }}</p>
                        @endforelse
                    </div>
                </div>
                <button type="submit" class="btn btn-primary">{{ __('admin.notifications.send_notification') }}</button>
            </form>
        </div>
        @include('admin.partials.pagination', ['items' => $users])
    </div>

    <div class="panel-card">
        <div class="panel-header">
            <h2>{{ __('admin.notifications.templates_title') }}</h2>
        </div>
        <div class="panel-body">
            <p class="text-muted" style="font-size: 13px; margin-bottom: 16px;">{{ __('admin.notifications.templates_note') }}</p>
            <form method="POST" action="{{ route('admin.notifications.templates') }}">
                @csrf
                <div class="form-group">
                    <label>{{ __('admin.notifications.welcome_title') }}</label>
                    <input type="text" name="notification_welcome_title" class="form-control" value="{{ $templates['notification_welcome_title'] ?? '' }}" placeholder="Welcome to AI Quantification Trading">
                </div>
                <div class="form-group">
                    <label>{{ __('admin.notifications.welcome_message') }}</label>
                    <textarea name="notification_welcome_message" class="form-control" rows="3" placeholder="Welcome message for new users">{{ $templates['notification_welcome_message'] ?? '' }}</textarea>
                </div>
                <div class="form-group">
                    <label>{{ __('admin.notifications.deposit_approved_title') }}</label>
                    <input type="text" name="notification_deposit_approved_title" class="form-control" value="{{ $templates['notification_deposit_approved_title'] ?? '' }}" placeholder="Deposit Approved">
                </div>
                <div class="form-group">
                    <label>{{ __('admin.notifications.deposit_approved_message') }}</label>
                    <textarea name="notification_deposit_approved_message" class="form-control" rows="3" placeholder="Message when deposit is approved">{{ $templates['notification_deposit_approved_message'] ?? '' }}</textarea>
                </div>
                <div class="form-group">
                    <label>{{ __('admin.notifications.withdrawal_approved_title') }}</label>
                    <input type="text" name="notification_withdraw_approved_title" class="form-control" value="{{ $templates['notification_withdraw_approved_title'] ?? '' }}" placeholder="Withdrawal Completed">
                </div>
                <div class="form-group">
                    <label>{{ __('admin.notifications.withdrawal_approved_message') }}</label>
                    <textarea name="notification_withdraw_approved_message" class="form-control" rows="3" placeholder="Message when withdrawal is approved">{{ $templates['notification_withdraw_approved_message'] ?? '' }}</textarea>
                </div>
                <button type="submit" class="btn btn-primary">{{ __('admin.notifications.save_templates') }}</button>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('selectAllUsers')?.addEventListener('change', function() {
    document.querySelectorAll('.user-checkbox').forEach(cb => cb.checked = this.checked);
});
document.getElementById('sendNotiForm')?.addEventListener('submit', function(e) {
    const checked = document.querySelectorAll('.user-checkbox:checked').length;
    if (checked === 0) {
        e.preventDefault();
        alert('Please select at least one user.');
    }
});
</script>
@endsection
