<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Admin Login</title>
        <link rel="stylesheet" href="{{ \App\Helpers\AssetHelper::adminAsset('admin.css') }}" type="text/css">
    </head>
    <body class="admin-login-body">
        <div class="login-shell">
            <div class="login-card">
                <div class="login-brand">Axue Admin</div>
                <div class="login-subtitle">Secure access for authorized admins</div>

                @if ($errors->any())
                    <div class="alert alert-error">{{ $errors->first() }}</div>
                @endif

                <form method="post" action="{{ route('admin.login.submit') }}">
                    @csrf
                    <label class="field">
                        <span>Email</span>
                        <input type="email" name="email" value="{{ old('email') }}" placeholder="admin@example.com" required>
                    </label>
                    <label class="field">
                        <span>Password</span>
                        <input type="password" name="password" placeholder="••••••••" required>
                    </label>
                    <button class="btn btn-primary full" type="submit">Login</button>
                </form>
            </div>
        </div>
    </body>
</html>

