@extends('admin.layout')

@section('content')
<div class="grid-2">
    <div class="panel-card">
        <div class="panel-header">
            <h2>{{ __('admin.financial.users_title') }}</h2>
            <div style="display: flex; gap: 8px; align-items: center; flex-wrap: wrap;">
                <form method="GET" action="{{ route('admin.financial') }}" class="search-form" style="display: flex; gap: 8px;">
                    <input type="text" name="search" placeholder="{{ __('admin.financial.search_wallet_placeholder') }}" value="{{ request('search') }}">
                    <button type="submit">{{ __('admin.financial.search') }}</button>
                </form>
                <button type="button" onclick="setAdjustAllUsers()" class="btn btn-sm btn-outline" style="white-space: nowrap;">Adjust all users</button>
            </div>
        </div>

        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>{{ __('admin.table.id') }}</th>
                        <th>{{ __('admin.financial.wallet_address') }}</th>
                        <th>{{ __('admin.financial.balance') }}</th>
                        <th>{{ __('admin.financial.locked') }}</th>
                        <th>{{ __('admin.financial.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($users as $user)
                    <tr>
                        <td>{{ $user->id }}</td>
                        <td style="word-break: break-all; max-width: 280px; font-size: 12px;" title="{{ $user->wallet_address }}">{{ $user->wallet_address }}</td>
                        <td title="Total Portfolio (USD) – matches Assets">${{ number_format($totalPortfolioByUser[$user->id] ?? 0, 2) }}</td>
                        <td>${{ number_format($user->locked_balance, 2) }}</td>
                        <td>
                            <button type="button" onclick="showAdjustForm({{ $user->id }}, {{ json_encode($user->wallet_address) }})" class="btn btn-sm btn-primary">{{ __('admin.financial.adjust') }}</button>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center">{{ __('admin.financial.no_users_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @include('admin.partials.pagination', ['items' => $users])
    </div>

    <div class="panel-card">
        <div class="panel-header">
            <h2>{{ __('admin.financial.adjustment_title') }}</h2>
        </div>
        <div class="panel-body">
            <form method="POST" action="{{ route('admin.financial.adjust') }}" id="adjustForm">
                @csrf
                <input type="hidden" name="user_id" id="user_id" value="">
                <input type="hidden" name="apply_to_all" id="apply_to_all" value="0">
                @if($errors->any())
                    <div class="form-group" style="color: #ef5350; font-size: 14px;">
                        {{ $errors->first() }}
                    </div>
                @endif
                @if(session('success'))
                    <div class="form-group" style="color: #22c55e; font-size: 14px;">
                        {{ session('success') }}
                    </div>
                @endif
                <div class="form-group">
                    <label>Apply to</label>
                    <div style="display: flex; gap: 16px; align-items: center; flex-wrap: wrap;">
                        <label style="display: flex; align-items: center; gap: 6px; cursor: pointer;">
                            <input type="radio" name="apply_to_radio" id="apply_one" value="one" checked>
                            <span>One user</span>
                        </label>
                        <label style="display: flex; align-items: center; gap: 6px; cursor: pointer;">
                            <input type="radio" name="apply_to_radio" id="apply_all" value="all">
                            <span>All users</span>
                        </label>
                    </div>
                </div>
                <div class="form-group" id="user_display_group">
                    <label>{{ __('admin.financial.user') }}</label>
                    <input type="text" id="user_display" class="form-control" readonly placeholder="Click « Adjust » on a row to select user" style="word-break: break-all; font-size: 12px;">
                </div>

                <div class="form-group">
                    <label>Coin</label>
                    <select name="coin_name" class="form-control" required>
                        @foreach($allowedCoins ?? ['USDT','BTC','ETH','BNB','SOL','XRP','ADA','DOGE','DOT','LTC','AVAX','TRX','LINK','BCH','XLM','UNI','ATOM','USDC','MATIC'] as $c)
                            <option value="{{ $c }}" {{ old('coin_name') === $c ? 'selected' : '' }}>{{ $c }}</option>
                        @endforeach
                    </select>
                    <small style="color: var(--muted); font-size: 12px; margin-top: 4px; display: block;">Select which balance (USDT, BTC, ETH, etc.) to add or deduct.</small>
                </div>

                <div class="form-group">
                    <label>{{ __('admin.financial.adjustment_type') }}</label>
                    <select name="type" class="form-control" required>
                        <option value="balance_add">Add balance</option>
                        <option value="balance_deduct">Deduct balance</option>
                    </select>
                    <small style="color: var(--muted); font-size: 12px; margin-top: 4px; display: block;">
                        {{ __('admin.financial.adjustment_note') }}
                    </small>
                </div>

                <div class="form-group">
                    <label>{{ __('admin.financial.amount') }}</label>
                    <input type="number" name="amount" step="0.00000001" min="0" class="form-control" value="{{ old('amount') }}" required>
                </div>

                <div class="form-group">
                    <label>{{ __('admin.financial.reason_required') }}</label>
                    <textarea name="reason" class="form-control" rows="3" required></textarea>
                </div>

                <button type="submit" class="btn btn-primary">{{ __('admin.financial.submit_adjustment') }}</button>
            </form>
        </div>
    </div>
</div>

<script>
function showAdjustForm(userId, walletAddress) {
    document.getElementById('apply_one').checked = true;
    document.getElementById('apply_to_all').value = '0';
    document.getElementById('user_id').value = userId;
    document.getElementById('user_display').value = walletAddress || ('User #' + userId);
    document.getElementById('user_display_group').style.display = 'block';
}
function setAdjustAllUsers() {
    document.getElementById('apply_all').checked = true;
    document.getElementById('apply_to_all').value = '1';
    document.getElementById('user_id').value = '';
    document.getElementById('user_display').value = 'All users (same amount per user)';
    document.getElementById('user_display_group').style.display = 'block';
}
document.addEventListener('DOMContentLoaded', function() {
    var form = document.getElementById('adjustForm');
    if (form) {
        form.addEventListener('submit', function() {
            document.getElementById('apply_to_all').value = document.getElementById('apply_all').checked ? '1' : '0';
            if (document.getElementById('apply_all').checked) {
                document.getElementById('user_id').value = '';
            }
        });
    }
    var applyOne = document.getElementById('apply_one');
    var applyAll = document.getElementById('apply_all');
    if (applyOne) applyOne.addEventListener('change', function() {
        document.getElementById('apply_to_all').value = '0';
        if (document.getElementById('user_display').value === 'All users (same amount per user)') {
            document.getElementById('user_display').value = '';
        }
    });
    if (applyAll) applyAll.addEventListener('change', function() {
        document.getElementById('apply_to_all').value = '1';
        document.getElementById('user_id').value = '';
        document.getElementById('user_display').value = 'All users (same amount per user)';
    });
});
</script>
@endsection

