@extends('admin.layout')

@section('content')
@if(session('success'))
<div class="alert alert-success" style="background: var(--primary-soft); color: var(--primary); padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid var(--primary);">
    {{ session('success') }}
</div>
@endif

<div class="panel-card">
    <div class="panel-header" style="flex-wrap: wrap; gap: 12px;">
        <div style="display: flex; align-items: center; gap: 12px; flex-wrap: wrap;">
            <h2 style="margin: 0;">Discover</h2>
            <a href="{{ route('admin.discover', ['tab' => 'demo']) }}" class="btn {{ ($tab ?? 'demo') === 'demo' ? 'btn-primary' : 'btn-outline' }}" style="padding: 6px 14px;">{{ __('admin.common.discover_posts_tab') }}</a>
            <a href="{{ route('admin.discover', ['tab' => 'users']) }}" class="btn {{ ($tab ?? '') === 'users' ? 'btn-primary' : 'btn-outline' }}" style="padding: 6px 14px;">{{ __('admin.common.users_discover_tab') }}</a>
        </div>
        @if(($tab ?? 'demo') === 'demo')
        <a href="{{ route('admin.discover.create') }}" class="btn btn-primary">{{ __('admin.common.add_demo_post_btn') }}</a>
        @endif
    </div>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>{{ __('admin.table.id') }}</th>
                    <th>{{ __('admin.table.author') }}</th>
                    <th>{{ __('admin.table.content') }}</th>
                    <th>{{ __('admin.table.likes') }}</th>
                    <th>{{ __('admin.table.comments') }}</th>
                    <th>{{ __('admin.table.created') }}</th>
                    <th>{{ __('admin.table.actions') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($posts as $post)
                @php $isDemo = $post->user_id === null; @endphp
                <tr>
                    <td>{{ $post->id }}</td>
                    <td>{{ $post->user_id ? 'User ' . $post->user_id : 'User ' . $post->demo_author_id }}</td>
                    <td>{{ Str::limit($post->content, 60) }}</td>
                    <td>{{ $post->likes_count ?? 0 }}</td>
                    <td>{{ $post->comments_count ?? 0 }}</td>
                    <td>{{ $post->created_at->format('Y-m-d H:i') }}</td>
                    <td>
                        @if($isDemo)
                        <a href="{{ route('admin.discover.edit', $post->id) }}" class="btn btn-sm btn-primary">{{ __('admin.common.edit') }}</a>
                        <form method="POST" action="{{ route('admin.discover.destroy', $post->id) }}" style="display: inline;" onsubmit="return confirm('{{ addslashes(__('admin.common.delete_confirm_post')) }}');">
                            @csrf
                            @method('DELETE')
                            <input type="hidden" name="_redirect_tab" value="{{ $tab ?? 'demo' }}">
                            <button type="submit" class="btn btn-sm btn-danger">{{ __('admin.common.delete') }}</button>
                        </form>
                        @else
                        <form method="POST" action="{{ route('admin.discover.destroy', $post->id) }}" style="display: inline;" onsubmit="return confirm('{{ addslashes(__('admin.common.delete_confirm_user_post')) }}');">
                            @csrf
                            @method('DELETE')
                            <input type="hidden" name="_redirect_tab" value="{{ $tab ?? 'demo' }}">
                            <button type="submit" class="btn btn-sm btn-danger">{{ __('admin.common.delete') }}</button>
                        </form>
                        @endif
                    </td>
                </tr>
                <tr>
                    <td colspan="7" style="background: var(--bg); padding: 12px;">
                        <strong>{{ __('admin.common.add_comment_as_demo') }}</strong>
                        @if(!empty($demoAuthorIds))
                        <form method="POST" action="{{ route('admin.discover.comments.store', $post->id) }}" style="display: flex; gap: 8px; margin-top: 8px; flex-wrap: wrap; align-items: center;">
                            @csrf
                            <label class="mb-0" style="font-weight: 500;">{{ __('admin.common.choose_id') }}</label>
                            <select name="demo_author_id" class="form-control" required style="width: auto; min-width: 140px;">
                                @foreach($demoAuthorIds as $aid)
                                    <option value="{{ $aid }}" {{ ($isDemo && (string)$post->demo_author_id === (string)$aid) ? 'selected' : '' }}>User {{ $aid }}</option>
                                @endforeach
                            </select>
                            <input type="text" name="body" class="form-control" placeholder="{{ __('admin.common.comment_placeholder') }}" required style="flex: 1; min-width: 200px;">
                            <button type="submit" class="btn btn-sm btn-primary">{{ __('admin.common.add_comment') }}</button>
                        </form>
                        @else
                        <p class="text-muted mb-0 mt-2">{{ __('admin.common.no_demo_authors') }}</p>
                        @endif
                        <div style="margin-top: 12px; padding-top: 12px; border-top: 1px solid var(--border);">
                            <strong>{{ __('admin.common.add_likes') }}</strong>
                            <form method="POST" action="{{ route('admin.discover.likes.store', $post->id) }}" style="display: inline-flex; gap: 8px; margin-top: 6px; align-items: center; flex-wrap: wrap;">
                                @csrf
                                <input type="number" name="count" value="1" min="1" max="500" class="form-control" style="width: 80px;">
                                <button type="submit" class="btn btn-sm btn-primary">{{ __('admin.common.add_like') }}</button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center">
                        @if(($tab ?? 'demo') === 'users')
                        {{ __('admin.common.no_user_posts') }}
                        @else
                        {{ __('admin.common.no_demo_posts') }} <a href="{{ route('admin.discover.create') }}">{{ __('admin.common.add_demo_post') }}</a>
                        @endif
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @include('admin.partials.pagination', ['items' => $posts])
</div>
@endsection
