@extends('admin.layout')

@section('content')
@if($errors->any())
<div class="alert alert-danger" style="background: #fef2f2; color: #b91c1c; padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid #fecaca;">
    <ul class="mb-0" style="padding-left: 20px;">
        @foreach($errors->all() as $err)
        <li>{{ $err }}</li>
        @endforeach
    </ul>
</div>
@endif
<div class="panel-card">
    <div class="panel-header">
        <h2>Add Demo Post</h2>
        <a href="{{ route('admin.discover') }}" class="btn btn-outline">Back</a>
    </div>
    <div class="panel-body">
        <p class="text-muted" style="margin-bottom: 16px;">Creates a post visible in Discover. Choose a 6-digit Author ID (100000–599999). Real user IDs start from 600000, so this range will not clash. Each demo author ID must be unique.</p>
        <form method="POST" action="{{ route('admin.discover.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label>Demo Author ID (6 digits, 100000–599999)</label>
                <input type="number" name="demo_author_id" class="form-control {{ $errors->has('demo_author_id') ? 'is-invalid' : '' }}" min="100000" max="599999" step="1" placeholder="e.g. 312459" required value="{{ old('demo_author_id', '') }}">
                @error('demo_author_id')
                <span class="invalid-feedback" style="display: block; color: #b91c1c; font-size: 0.875rem;">{{ $message }}</span>
                @enderror
                <small class="text-muted">Shown as "User XXXXXX" in the feed. Must be &lt; 600000 and not already used by another demo post.</small>
            </div>
            <div class="form-group">
                <label>Content</label>
                <textarea name="content" class="form-control" rows="5" required placeholder="Post content...">{{ old('content') }}</textarea>
            </div>
            <div class="form-group">
                <label>Image (optional)</label>
                <input type="file" name="image" id="createPostImage" accept="image/*" class="form-control">
                <div id="createPostImagePreview" style="margin-top: 10px; display: none;">
                    <span style="font-size: 13px; color: var(--muted);">Preview:</span>
                    <div style="margin-top: 6px;"><img id="createPostImagePreviewImg" src="" alt="Preview" style="max-width: 280px; max-height: 200px; object-fit: contain; border-radius: 8px; border: 1px solid var(--border);"></div>
                </div>
            </div>
            <button type="submit" class="btn btn-primary">Create Post</button>
        </form>
    </div>
</div>
<script>
document.getElementById('createPostImage').addEventListener('change', function() {
    var preview = document.getElementById('createPostImagePreview');
    var img = document.getElementById('createPostImagePreviewImg');
    if (this.files && this.files[0]) {
        img.src = URL.createObjectURL(this.files[0]);
        preview.style.display = 'block';
    } else {
        img.src = '';
        preview.style.display = 'none';
    }
});
</script>
@endsection
