@extends('admin.layout')

@section('content')
<div class="panel-card">
    <div class="panel-header">
        <h2>{{ __('admin.audit_logs.title') }}</h2>
        <form method="GET" action="{{ route('admin.audit-logs') }}" class="search-form">
            <input type="number" name="admin_user_id" placeholder="{{ __('admin.audit_logs.admin_id_placeholder') }}" value="{{ request('admin_user_id') }}">
            <input type="text" name="action" placeholder="{{ __('admin.audit_logs.action_placeholder') }}" value="{{ request('action') }}">
            <button type="submit">{{ __('admin.audit_logs.filter') }}</button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>{{ __('admin.table.id') }}</th>
                    <th>{{ __('admin.audit_logs.admin') }}</th>
                    <th>{{ __('admin.audit_logs.action') }}</th>
                    <th>{{ __('admin.audit_logs.model') }}</th>
                    <th>{{ __('admin.audit_logs.changes') }}</th>
                    <th>{{ __('admin.audit_logs.reason') }}</th>
                    <th>{{ __('admin.audit_logs.date') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($logs as $log)
                <tr>
                    <td>{{ $log->id }}</td>
                    <td>{{ $log->adminUser->email ?? 'N/A' }}</td>
                    <td>{{ $log->action }}</td>
                    <td>{{ class_basename($log->model_type) }} #{{ $log->model_id }}</td>
                    <td>{{ $log->changes }}</td>
                    <td>{{ $log->reason }}</td>
                    <td>{{ $log->created_at->format('Y-m-d H:i') }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center">{{ __('admin.audit_logs.no_found') }}</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @include('admin.partials.pagination', ['items' => $logs])
</div>
@endsection

