@extends('admin.layout')

@section('content')
@if(session('success'))
<div class="alert alert-success" style="background: var(--primary-soft); color: var(--primary); padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid var(--primary);">
    {{ session('success') }}
</div>
@endif

<div class="panel-card">
    <div class="panel-header">
        <h2>{{ __('admin.nav.announcements') }}</h2>
        <a href="{{ route('admin.announcements.create') }}" class="btn btn-primary">{{ __('admin.common.add_announcement_btn') }}</a>
    </div>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>{{ __('admin.table.id') }}</th>
                    <th>{{ __('admin.table.author') }}</th>
                    <th>{{ __('admin.table.content') }}</th>
                    <th>{{ __('admin.table.likes') }}</th>
                    <th>{{ __('admin.table.comments') }}</th>
                    <th>{{ __('admin.table.created') }}</th>
                    <th>{{ __('admin.table.actions') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($posts as $post)
                <tr>
                    <td>{{ $post->id }}</td>
                    <td>AI Bot</td>
                    <td>{{ Str::limit($post->content, 60) }}</td>
                    <td>{{ $post->likes_count ?? 0 }}</td>
                    <td>{{ $post->comments_count ?? 0 }}</td>
                    <td>{{ $post->created_at->format('Y-m-d H:i') }}</td>
                    <td>
                        <a href="{{ route('admin.announcements.edit', $post->id) }}" class="btn btn-sm btn-primary">{{ __('admin.common.edit') }}</a>
                        <form method="POST" action="{{ route('admin.announcements.destroy', $post->id) }}" style="display: inline;" onsubmit="return confirm('{{ addslashes(__('admin.common.delete_confirm_announcement')) }}');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger">{{ __('admin.common.delete') }}</button>
                        </form>
                    </td>
                </tr>
                <tr>
                    <td colspan="7" style="background: var(--bg); padding: 12px;">
                        <strong>{{ __('admin.common.add_comment_discover_id') }}</strong>
                        @if(!empty($demoAuthorIds))
                        <form method="POST" action="{{ route('admin.announcements.comments.store', $post->id) }}" style="display: flex; gap: 8px; margin-top: 8px; flex-wrap: wrap; align-items: center;">
                            @csrf
                            <label class="mb-0" style="font-weight: 500;">{{ __('admin.common.choose_id') }}</label>
                            <select name="demo_author_id" class="form-control" required style="width: auto; min-width: 140px;">
                                @foreach($demoAuthorIds as $aid)
                                    <option value="{{ $aid }}">User {{ $aid }}</option>
                                @endforeach
                            </select>
                            <input type="text" name="body" class="form-control" placeholder="{{ __('admin.common.comment_placeholder') }}" required style="flex: 1; min-width: 200px;">
                            <button type="submit" class="btn btn-sm btn-primary">{{ __('admin.common.add_comment') }}</button>
                        </form>
                        @else
                        <p class="text-muted mb-0 mt-2">{{ __('admin.common.no_demo_authors_ann') }}</p>
                        @endif
                        <div style="margin-top: 12px; padding-top: 12px; border-top: 1px solid var(--border);">
                            <strong>{{ __('admin.common.add_likes') }}</strong>
                            <form method="POST" action="{{ route('admin.announcements.likes.store', $post->id) }}" style="display: inline-flex; gap: 8px; margin-top: 6px; align-items: center; flex-wrap: wrap;">
                                @csrf
                                <input type="number" name="count" value="1" min="1" max="500" class="form-control" style="width: 80px;">
                                <button type="submit" class="btn btn-sm btn-primary">{{ __('admin.common.add_like') }}</button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center">{{ __('admin.common.no_announcements') }} <a href="{{ route('admin.announcements.create') }}">{{ __('admin.common.add_announcement') }}</a></td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @include('admin.partials.pagination', ['items' => $posts])
</div>
@endsection
