@extends('admin.layout')

@section('content')
<div class="panel-card">
    <div class="panel-header">
        <h2>Edit Announcement</h2>
        <a href="{{ route('admin.announcements') }}" class="btn btn-outline">Back</a>
    </div>
    <div class="panel-body">
        <form method="POST" action="{{ route('admin.announcements.update', $post->id) }}" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label>Author (read-only)</label>
                <input type="text" class="form-control" value="AI Bot" readonly>
            </div>
            <div class="form-group">
                <label>Content</label>
                <textarea name="content" class="form-control" rows="5" required>{{ $post->content }}</textarea>
            </div>
            <div class="form-group">
                <label>Current image</label>
                @if($post->image_path)
                <div style="margin-bottom: 8px;"><img src="{{ asset('storage/' . $post->image_path) }}" alt="Post" style="max-width: 200px; border-radius: 8px;"></div>
                @else
                <p class="text-muted">No image</p>
                @endif
            </div>
            <div class="form-group">
                <label>Replace image (optional)</label>
                <input type="file" name="image" id="editAnnImage" accept="image/*" class="form-control">
                <div id="editAnnImagePreview" style="margin-top: 10px; display: none;">
                    <span style="font-size: 13px; color: var(--muted);">Preview:</span>
                    <div style="margin-top: 6px;"><img id="editAnnImagePreviewImg" src="" alt="Preview" style="max-width: 280px; max-height: 200px; object-fit: contain; border-radius: 8px; border: 1px solid var(--border);"></div>
                </div>
            </div>
            <button type="submit" class="btn btn-primary">Update</button>
        </form>
    </div>
</div>
<script>
document.getElementById('editAnnImage').addEventListener('change', function() {
    var preview = document.getElementById('editAnnImagePreview');
    var img = document.getElementById('editAnnImagePreviewImg');
    if (this.files && this.files[0]) {
        img.src = URL.createObjectURL(this.files[0]);
        preview.style.display = 'block';
    } else {
        img.src = '';
        preview.style.display = 'none';
    }
});
</script>
@endsection
