@extends('admin.layout')

@section('content')
@if($errors->any())
<div class="alert alert-danger" style="background: #fef2f2; color: #b91c1c; padding: 12px 16px; border-radius: 8px; margin-bottom: 16px; border: 1px solid #fecaca;">
    <ul class="mb-0" style="padding-left: 20px;">
        @foreach($errors->all() as $err)
        <li>{{ $err }}</li>
        @endforeach
    </ul>
</div>
@endif
<div class="panel-card">
    <div class="panel-header">
        <h2>Add Announcement</h2>
        <a href="{{ route('admin.announcements') }}" class="btn btn-outline">Back</a>
    </div>
    <div class="panel-body">
        <p class="text-muted" style="margin-bottom: 16px;">Announcements are shown as from AI Bot (platform).</p>
        <form method="POST" action="{{ route('admin.announcements.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label>Content</label>
                <textarea name="content" class="form-control" rows="5" required placeholder="Announcement content...">{{ old('content') }}</textarea>
            </div>
            <div class="form-group">
                <label>Image (optional)</label>
                <input type="file" name="image" id="createAnnImage" accept="image/*" class="form-control">
                <div id="createAnnImagePreview" style="margin-top: 10px; display: none;">
                    <span style="font-size: 13px; color: var(--muted);">Preview:</span>
                    <div style="margin-top: 6px;"><img id="createAnnImagePreviewImg" src="" alt="Preview" style="max-width: 280px; max-height: 200px; object-fit: contain; border-radius: 8px; border: 1px solid var(--border);"></div>
                </div>
            </div>
            <button type="submit" class="btn btn-primary">Create Announcement</button>
        </form>
    </div>
</div>
<script>
document.getElementById('createAnnImage').addEventListener('change', function() {
    var preview = document.getElementById('createAnnImagePreview');
    var img = document.getElementById('createAnnImagePreviewImg');
    if (this.files && this.files[0]) {
        img.src = URL.createObjectURL(this.files[0]);
        preview.style.display = 'block';
    } else {
        img.src = '';
        preview.style.display = 'none';
    }
});
</script>
@endsection
