@extends('admin.layout')

@section('content')
<div class="panel-card">
    <div class="panel-header">
        <h2>{{ __('admin.ai_trade.bots_title') }}</h2>
        <form method="GET" action="{{ route('admin.ai-trade') }}" class="search-form">
            <select name="status">
                <option value="">{{ __('admin.users.all_status') }}</option>
                <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>{{ __('admin.ai_trade.active') }}</option>
                <option value="paused" {{ request('status') === 'paused' ? 'selected' : '' }}>{{ __('admin.ai_trade.paused') }}</option>
                <option value="stopped" {{ request('status') === 'stopped' ? 'selected' : '' }}>{{ __('admin.ai_trade.stopped') }}</option>
                <option value="closed" {{ request('status') === 'closed' ? 'selected' : '' }}>{{ __('admin.ai_trade.closed') }}</option>
            </select>
            <button type="submit">{{ __('admin.deposits.filter') }}</button>
        </form>
    </div>

    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>{{ __('admin.table.id') }}</th>
                    <th>{{ __('admin.ai_trade.user_id') }}</th>
                    <th>{{ __('admin.ai_trade.name') }}</th>
                    <th>{{ __('admin.ai_trade.trading_pair') }}</th>
                    <th>{{ __('admin.ai_trade.amount') }}</th>
                    <th>{{ __('admin.ai_trade.total_profit') }}</th>
                    <th>{{ __('admin.ai_trade.total_loss') }}</th>
                    <th>{{ __('admin.ai_trade.net_pl') }}</th>
                    <th>{{ __('admin.ai_trade.status') }}</th>
                    <th>{{ __('admin.table.actions') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($bots as $bot)
                <tr>
                    <td>{{ $bot->id }}</td>
                    <td>{{ str_pad($bot->user->id, 6, '0', STR_PAD_LEFT) }}</td>
                    <td>{{ $bot->name }}</td>
                    <td>{{ $bot->trading_pair }}</td>
                    <td>${{ number_format($bot->amount, 2) }}</td>
                    @php
                        $profit = $bot->live_pl ? $bot->live_pl['totalProfit'] : (float)$bot->total_profit;
                        $loss = $bot->live_pl ? $bot->live_pl['totalLoss'] : (float)$bot->total_loss;
                        $net = $profit - $loss;
                    @endphp
                    <td style="color: #26a69a;">${{ number_format($profit, 2) }}{{ $bot->live_pl ? ' <small style="opacity:0.8">(live)</small>' : '' }}</td>
                    <td style="color: #ef5350;">${{ number_format($loss, 2) }}</td>
                    <td style="color: {{ $net >= 0 ? '#26a69a' : '#ef5350' }};">
                        ${{ number_format($net, 2) }}
                    </td>
                    <td>
                        <span class="badge badge-{{ $bot->status === 'active' ? 'success' : ($bot->status === 'stopped' ? 'danger' : ($bot->status === 'closed' ? 'secondary' : 'warning')) }}">
                            {{ __('admin.ai_trade.' . $bot->status) }}
                        </span>
                        @if($bot->status === 'active' && $bot->admin_activated_at)
                        <div style="font-size: 11px; color: #22c55e; margin-top: 4px;">Started: {{ $bot->admin_activated_at->format('M d, H:i') }}</div>
                        @endif
                    </td>
                    <td>
                        <a href="{{ route('admin.ai-trade.show', $bot->id) }}" class="btn btn-sm btn-primary">{{ __('admin.ai_trade.view') }}</a>
                        @if($bot->status !== 'closed')
                        <form id="close-bot-form-{{ $bot->id }}" method="POST" action="{{ route('admin.ai-trade.close', $bot->id) }}" class="d-inline">
                            @csrf
                            <button type="button" class="btn btn-sm btn-secondary btn-close-bot" data-form-id="close-bot-form-{{ $bot->id }}">{{ __('admin.ai_trade.close_bot') }}</button>
                        </form>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="10" class="text-center">{{ __('admin.ai_trade.no_found') }}</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @include('admin.partials.pagination', ['items' => $bots])
</div>

{{-- Custom confirmation modal instead of browser confirm --}}
<div id="closeBotModal" class="admin-modal" style="display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 9999; align-items: center; justify-content: center;">
    <div class="admin-modal-content" style="background: var(--card-bg, #1e293b); border-radius: 12px; padding: 24px; max-width: 400px; box-shadow: 0 20px 40px rgba(0,0,0,0.3); border: 1px solid var(--border-color, #334155);">
        <h3 style="margin: 0 0 12px 0; font-size: 18px; color: var(--text, #f1f5f9);">{{ __('admin.ai_trade.close_bot') }}?</h3>
        <p style="margin: 0 0 20px 0; color: var(--muted, #94a3b8); font-size: 14px;">{{ __('admin.ai_trade.close_confirm') }}</p>
        <div style="display: flex; gap: 12px; justify-content: flex-end;">
            <button type="button" id="closeBotModalCancel" class="btn btn-outline" style="padding: 8px 16px;">{{ __('admin.common.cancel') }}</button>
            <button type="button" id="closeBotModalConfirm" class="btn btn-primary" style="padding: 8px 16px;">{{ __('admin.deposits.confirm') }}</button>
        </div>
    </div>
</div>

<script>
(function() {
    var modal = document.getElementById('closeBotModal');
    var formToSubmit = null;
    document.querySelectorAll('.btn-close-bot').forEach(function(btn) {
        btn.addEventListener('click', function() {
            formToSubmit = document.getElementById(this.getAttribute('data-form-id'));
            if (modal) modal.style.display = 'flex';
        });
    });
    if (modal) {
        document.getElementById('closeBotModalCancel').onclick = function() {
            modal.style.display = 'none';
            formToSubmit = null;
        };
        document.getElementById('closeBotModalConfirm').onclick = function() {
            if (formToSubmit) formToSubmit.submit();
            modal.style.display = 'none';
            formToSubmit = null;
        };
        modal.addEventListener('click', function(e) {
            if (e.target === modal) { modal.style.display = 'none'; formToSubmit = null; }
        });
    }
})();
</script>
@endsection

