@extends('admin.layout')

@section('content')
@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif
@if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
@endif
<div class="grid-2">
    <div class="panel-card">
        <div class="panel-header">
            <h2>{{ __('admin.admins.title') }}</h2>
        </div>

        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>{{ __('admin.table.id') }}</th>
                        <th>{{ __('admin.admins.username') }}</th>
                        <th>{{ __('admin.admins.email') }}</th>
                        <th>{{ __('admin.admins.role') }}</th>
                        <th>{{ __('admin.admins.status') }}</th>
                        <th>{{ __('admin.table.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($admins as $admin)
                    <tr>
                        <td>{{ $admin->id }}</td>
                        <td>{{ $admin->username }}</td>
                        <td>{{ $admin->email }}</td>
                        <td>
                            @if($admin->role === 'super_admin')
                            <span class="badge badge-warning">{{ __('admin.admins.role_super_admin') }}</span>
                            @elseif($admin->role === 'service_admin')
                            <span class="badge badge-secondary">{{ __('admin.admins.role_service_admin') }}</span>
                            @else
                            <span class="badge badge-info">{{ __('admin.admins.role_admin') }}</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge {{ $admin->is_active ? 'badge-success' : 'badge-danger' }}">
                                {{ $admin->is_active ? __('admin.admins.active') : __('admin.admins.inactive') }}
                            </span>
                        </td>
                        <td>
                            <button onclick="editAdmin({{ $admin->id }})" class="btn btn-sm btn-primary">{{ __('admin.admins.edit') }}</button>
                            @if($admin->role !== 'super_admin')
                            <form method="POST" action="{{ route('admin.admins.destroy', $admin->id) }}" style="display:inline;" onsubmit="return confirm({{ json_encode(__('admin.admins.delete_confirm')) }});">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">{{ __('admin.admins.delete') }}</button>
                            </form>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">{{ __('admin.admins.no_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="panel-card">
        <div class="panel-header">
            <h2>{{ __('admin.admins.add_edit_title') }}</h2>
        </div>
        <div class="panel-body">
            <form method="POST" action="{{ route('admin.admins.store') }}" id="adminForm">
                @csrf
                <div class="form-group">
                    <label>{{ __('admin.admins.username') }}</label>
                    <input type="text" name="username" class="form-control" required>
                </div>

                <div class="form-group">
                    <label>{{ __('admin.admins.email') }}</label>
                    <input type="email" name="email" class="form-control" required>
                </div>

                <div class="form-group">
                    <label>{{ __('admin.admins.password') }}</label>
                    <input type="password" name="password" class="form-control" required>
                </div>

                <div class="form-group">
                    <label>{{ __('admin.admins.role') }}</label>
                    <select name="role" class="form-control" required>
                        <option value="admin">{{ __('admin.admins.role_admin') }}</option>
                        <option value="service_admin">{{ __('admin.admins.role_service_admin') }}</option>
                        <option value="super_admin">{{ __('admin.admins.role_super_admin') }}</option>
                    </select>
                </div>

                <button type="submit" class="btn btn-primary">{{ __('admin.admins.save_admin') }}</button>
            </form>
        </div>
    </div>
</div>
@endsection

