<?php

return [
    'subtitle' => 'Professional admin controls and monitoring',
    'logout' => 'Logout',
    'have_an_issue' => 'Have an issue?',
    'language' => 'Language',
    'english' => 'English',
    'chinese' => '中文',

    'dashboard' => [
        'total_users' => 'Total Users',
        'total_users_meta' => 'Active and verified accounts',
        'total_deposits' => 'Total Deposits',
        'total_deposits_meta' => 'All-time confirmed',
        'total_withdrawals' => 'Total Withdrawals',
        'total_withdrawals_meta' => 'All-time processed',
        'active_bots' => 'Active Bots',
        'active_bots_meta' => 'Running strategies',
        'open_orders' => 'Open Orders',
        'open_orders_meta' => 'Across all users',
        'risk_alerts' => 'Risk Alerts',
        'risk_alerts_meta' => 'Requires review',
        'panel_ai_trade_title' => 'AI Trade Control',
        'panel_ai_trade_desc' => 'Enable/disable strategies, tune leverage, set risk limits, and review performance logs.',
        'panel_ai_trade_manage' => 'Manage Strategies',
        'panel_ai_trade_logs' => 'View Logs',
        'panel_financial_title' => 'Financial Operations',
        'panel_financial_desc' => 'Approve deposits/withdrawals, adjust user balances with mandatory reason logging.',
        'panel_financial_queue' => 'Review Queue',
        'panel_financial_audit' => 'Audit Logs',
        'panel_users_title' => 'User Controls',
        'panel_users_desc' => 'Manage KYC status, account access, referral tiers, and support escalations.',
        'panel_users_list' => 'User List',
        'panel_users_support' => 'Support',
    ],

    'nav' => [
        'dashboard' => 'Dashboard',
        'users' => 'User Management',
        'deposits' => 'Deposits',
        'withdrawals' => 'Withdrawals',
        'ai_trade' => 'AI Trade Systems',
        'financial' => 'Financial / Ledger',
        'referrals' => 'Invitations / Referrals',
        'content' => 'Content / Tips',
        'support' => 'Customer Service Management',
        'notifications' => 'Notifications',
        'discover' => 'Discover Posts',
        'announcements' => 'Announcements',
        'audit_logs' => 'Audit Logs',
        'super_admin' => 'Super Admin',
        'wallets' => 'Wallet Management',
        'admins' => 'Admin Management',
        'system' => 'System / Settings',
    ],

    'brand' => [
        'name' => 'Axue',
        'console' => 'Admin Console',
    ],

    'table' => [
        'id' => 'ID',
        'author' => 'Author',
        'content' => 'Content',
        'likes' => 'Likes',
        'comments' => 'Comments',
        'created' => 'Created',
        'actions' => 'Actions',
    ],

    'common' => [
        'edit' => 'Edit',
        'delete' => 'Delete',
        'back' => 'Back',
        'cancel' => 'Cancel',
        'add_comment' => 'Add Comment',
        'choose_id' => 'Choose ID',
        'comment_placeholder' => 'Comment text...',
        'add_like' => '♥ Add Like',
        'add_likes' => 'Add like(s):',
        'no_demo_authors' => 'No demo authors yet. Add a demo post first.',
        'no_demo_authors_ann' => 'No demo authors. Add a Discover demo post first.',
        'add_demo_post' => 'Add demo post',
        'add_announcement' => 'Add announcement',
        'add_comment_as_demo' => 'Add comment (as demo user):',
        'add_comment_discover_id' => 'Add comment (Choose ID from Discover demo posts):',
        'discover_posts_tab' => 'Discover Posts',
        'users_discover_tab' => 'Users Discover',
        'add_demo_post_btn' => 'Add Demo Post',
        'add_announcement_btn' => 'Add Announcement',
        'no_demo_posts' => 'No demo posts yet.',
        'no_user_posts' => 'No user discover posts yet.',
        'no_announcements' => 'No announcements yet.',
        'delete_confirm_post' => 'Delete this post?',
        'delete_confirm_user_post' => 'Delete this user post?',
        'delete_confirm_announcement' => 'Delete this announcement?',
    ],

    'users' => [
        'title' => 'Users',
        'search_placeholder' => 'Search by wallet, name, email...',
        'all_status' => 'All Status',
        'active' => 'Active',
        'inactive' => 'Inactive',
        'search' => 'Search',
        'wallet_address' => 'Wallet Address',
        'name' => 'Name',
        'score' => 'Score',
        'balance' => 'Balance',
        'status' => 'Status',
        'verified' => 'Verified',
        'view' => 'View',
        'verify_user' => 'Verify User',
        'set_reset_pin' => 'Set/Reset PIN',
        'no_found' => 'No users found',
        'pending' => 'Pending',
        'user_details' => 'User Details',
        'user_information' => 'User Information',
        'update_user' => 'Update User',
        'user_id' => 'User ID',
        'email' => 'Email',
        'account_weight_score' => 'Account Weight Score',
        'authorization_quota' => 'Authorization Quota',
        'available_quota' => 'Available Quota',
        'locked_balance' => 'Locked Balance',
        'withdrawal_pin' => 'Withdrawal PIN',
        'set' => 'Set',
        'not_set' => 'Not set',
        'reason_required' => 'Reason (Required)',
        'range_1_100' => 'Range: 1 - 100',
        'verify_user_btn' => 'Verify User',
        'reset_withdrawal_pin' => 'Reset Withdrawal PIN',
        'verify_modal_title' => 'Verify User',
        'verify_confirm_text' => 'Are you sure you want to verify user',
        'verify_kyc_note' => 'This action will mark the user as KYC verified.',
        'confirm_verify' => 'Confirm Verify',
        'pin_modal_title' => 'Set / Reset Withdrawal PIN',
        'pin_modal_user' => 'User:',
        'pin_modal_note' => 'Set a new 6-digit Withdrawal PIN for this user. They will use it to confirm withdrawals.',
        'new_pin' => 'New PIN (6 digits)',
        'confirm_new_pin' => 'Confirm New PIN',
        'clear_pin' => 'Clear PIN',
        'set_pin_btn' => 'Set PIN',
        'pin_must_6' => 'PIN must be exactly 6 digits.',
        'pin_no_match' => 'PIN and confirmation do not match.',
        'delete_user' => 'Delete User',
        'delete_user_modal_title' => 'Delete User',
        'delete_user_confirm_text' => 'Are you sure you want to delete user',
        'delete_user_cannot_undo' => 'This action cannot be undone.',
        'confirm_delete' => 'Confirm Delete',
        'user_deleted' => 'User deleted successfully.',
        'reset_pin_confirm' => 'Reset this user\'s Withdrawal PIN? They will need to set a new PIN in Settings to confirm withdrawals again.',
    ],

    'deposits' => [
        'title' => 'Deposits',
        'filter' => 'Filter',
        'user' => 'User',
        'network' => 'Network',
        'amount' => 'Amount',
        'voucher' => 'Voucher',
        'date' => 'Date',
        'view' => 'View',
        'download' => 'Download',
        'no_voucher' => 'No voucher',
        'pending' => 'Pending',
        'confirmed' => 'Confirmed',
        'rejected' => 'Rejected',
        'confirm' => 'Confirm',
        'reject' => 'Reject',
        'rejection_reason' => 'Rejection reason',
        'no_found' => 'No deposits found',
        'confirm_modal_title' => 'Confirm Deposit',
        'confirm_question' => 'Are you sure you want to confirm this deposit?',
        'confirm_note' => 'This action will credit the user\'s balance and cannot be undone.',
        'confirm_btn' => 'Confirm Deposit',
        'transaction_voucher' => 'Transaction Voucher',
    ],

    'withdrawals' => [
        'title' => 'Withdrawals',
        'filter' => 'Filter',
        'user' => 'User',
        'coin' => 'Coin',
        'network' => 'Network',
        'address' => 'Address',
        'amount' => 'Amount',
        'status' => 'Status',
        'date' => 'Date',
        'pending' => 'Pending',
        'processing' => 'Processing',
        'completed' => 'Completed',
        'rejected' => 'Rejected',
        'complete' => 'Complete',
        'reject' => 'Reject',
        'reason' => 'Reason',
        'processed' => 'Processed',
        'no_found' => 'No withdrawals found',
        'copy_address' => 'Copy',
    ],

    'ai_trade' => [
        'bots_title' => 'AI Trade Bots',
        'user_id' => 'User ID',
        'name' => 'Name',
        'trading_pair' => 'Trading Pair',
        'amount' => 'Amount',
        'total_profit' => 'Total Profit',
        'total_loss' => 'Total Loss',
        'net_pl' => 'Net P/L',
        'status' => 'Status',
        'active' => 'Active',
        'paused' => 'Paused',
        'stopped' => 'Stopped',
        'closed' => 'Closed',
        'view' => 'View',
        'close_bot' => 'Close bot',
        'close_confirm' => 'Close this bot? Final P/L will be applied from win/loss %.',
        'no_found' => 'No bots found',
    ],

    'pagination' => [
        'total' => 'Total',
        'per_page' => ':count/page',
        'go_to' => 'Go to',
    ],

    'financial' => [
        'users_title' => 'Users',
        'search_wallet_placeholder' => 'Search wallet address...',
        'search' => 'Search',
        'wallet_address' => 'Wallet Address',
        'balance' => 'Balance',
        'locked' => 'Locked',
        'actions' => 'Actions',
        'adjust' => 'Adjust',
        'no_users_found' => 'No users found',
        'adjustment_title' => 'Financial Adjustment',
        'user' => 'User',
        'adjustment_type' => 'Adjustment Type',
        'add_usdt_balance' => 'Add USDT Balance',
        'deduct_usdt_balance' => 'Deduct USDT Balance',
        'adjustment_note' => 'Note: This adjusts the user\'s USDT balance only. Win/Loss adjustments are available in AI Trade Management.',
        'amount' => 'Amount',
        'reason_required' => 'Reason (Required)',
        'submit_adjustment' => 'Submit Adjustment',
    ],

    'referrals' => [
        'title' => 'Referrals',
        'user_id_placeholder' => 'User ID',
        'filter' => 'Filter',
        'referrer' => 'Referrer',
        'referred_user' => 'Referred User',
        'level' => 'Level',
        'total_earnings' => 'Total Earnings',
        'date' => 'Date',
        'no_found' => 'No referrals found',
    ],

    'content' => [
        'title' => 'Content Management',
        'coming_soon' => 'Content management system coming soon.',
    ],

    'support' => [
        'chat_title' => 'Customer Service Chat',
        'support_tickets' => 'Support Tickets',
        'search_by_id_placeholder' => 'Search by ID...',
        'user_id' => 'User ID',
        'pending' => 'Pending',
        'open' => 'Open',
        'resolved' => 'Resolved',
        'closed' => 'Closed',
        'no_tickets_found' => 'No tickets found',
        'select_ticket' => 'Select a ticket to start chatting',
        'type_message_placeholder' => 'Type your message...',
        'send' => 'Send',
        'sending' => 'Sending...',
        'edit_message' => 'Edit Message',
        'message' => 'Message',
        'current_image' => 'Current Image',
        'replace_image' => 'Replace Image (optional)',
        'save_changes' => 'Save Changes',
        'delete_message' => 'Delete message',
        'delete_message_confirm' => 'Are you sure you want to delete this message? This action cannot be undone.',
        'deleting' => 'Deleting...',
        'save_image' => 'Save Image',
    ],

    'notifications' => [
        'send_title' => 'Send notification to users',
        'search_placeholder' => 'Search by ID, wallet, name...',
        'search' => 'Search',
        'message_type' => 'Message type',
        'maintenance' => 'Maintenance',
        'success' => 'Success',
        'info' => 'Info',
        'custom' => 'Custom',
        'title_label' => 'Title',
        'title_placeholder' => 'Notification title',
        'message_label' => 'Message',
        'message_placeholder' => 'Notification message',
        'select_users' => 'Select users',
        'select_all_page' => 'Select all on this page',
        'no_users_found' => 'No users found.',
        'send_notification' => 'Send notification',
        'templates_title' => 'Auto-notification templates',
        'templates_note' => 'These templates are used for welcome, deposit approved, and withdrawal approved notifications. Edit and save to update.',
        'welcome_title' => 'Welcome – Title',
        'welcome_message' => 'Welcome – Message',
        'deposit_approved_title' => 'Deposit approved – Title',
        'deposit_approved_message' => 'Deposit approved – Message',
        'withdrawal_approved_title' => 'Withdrawal approved – Title',
        'withdrawal_approved_message' => 'Withdrawal approved – Message',
        'save_templates' => 'Save templates',
    ],

    'audit_logs' => [
        'title' => 'Audit Logs',
        'admin_id_placeholder' => 'Admin ID',
        'action_placeholder' => 'Action',
        'filter' => 'Filter',
        'admin' => 'Admin',
        'action' => 'Action',
        'model' => 'Model',
        'changes' => 'Changes',
        'reason' => 'Reason',
        'date' => 'Date',
        'no_found' => 'No audit logs found',
    ],

    'wallets' => [
        'title' => 'Wallets',
        'add_edit_title' => 'Add/Edit Wallet',
        'name' => 'Name',
        'name_optional' => 'Name (Optional)',
        'auto_generated_placeholder' => 'Auto-generated from network',
        'leave_empty_note' => 'Leave empty to auto-generate from network',
        'coin_name' => 'Coin Name',
        'coin_placeholder' => 'e.g., USDT, BTC, ETH',
        'coin_hint' => 'Coin/Token name (e.g., USDT, BTC, ETH)',
        'network' => 'Network',
        'network_placeholder' => 'e.g., TRC-20, ERC-20, BTC',
        'address' => 'Address',
        'qr_code_image' => 'QR Code Image',
        'choose_file' => 'Choose file',
        'no_file_chosen' => 'No file chosen',
        'qr_upload_hint' => 'Upload QR code image for deposit address',
        'active' => 'Active',
        'inactive' => 'Inactive',
        'save_wallet' => 'Save Wallet',
        'update_wallet' => 'Update Wallet',
        'edit' => 'Edit',
        'view_qr' => 'View QR',
        'delete' => 'Delete',
        'no_qr' => 'No QR',
        'no_found' => 'No wallets found',
        'qr_code' => 'QR Code',
        'download_qr' => 'Download QR Code',
        'copy_address' => 'Copy Address',
        'remove' => 'Remove',
        'current_qr' => 'Current QR Code:',
        'delete_confirm' => 'Delete this wallet?',
    ],

    'admins' => [
        'title' => 'Admins',
        'add_edit_title' => 'Add/Edit Admin',
        'username' => 'Username',
        'email' => 'Email',
        'password' => 'Password',
        'role' => 'Role',
        'role_admin' => 'Admin',
        'role_service_admin' => 'Service Admin',
        'role_super_admin' => 'Super Admin',
        'status' => 'Status',
        'active' => 'Active',
        'inactive' => 'Inactive',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'save_admin' => 'Save Admin',
        'no_found' => 'No admins found',
        'delete_confirm' => 'Delete this admin?',
        'cannot_delete_super_admin' => 'Super Admin cannot be deleted.',
    ],

    'system' => [
        'title' => 'System Settings',
        'system_name' => 'System Name',
        'save_settings' => 'Save Settings',
    ],
];
