<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AdminUser;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    public function run(): void
    {
        // Create Super Admin
        AdminUser::firstOrCreate(
            ['email' => 'admin@example.com'],
            [
                'username' => 'superadmin',
                'email' => 'admin@example.com',
                'password' => Hash::make('admin12345'),
                'role' => 'super_admin',
                'is_active' => true,
            ]
        );

        // Create Regular Admin
        AdminUser::firstOrCreate(
            ['email' => 'admin2@example.com'],
            [
                'username' => 'admin',
                'email' => 'admin2@example.com',
                'password' => Hash::make('admin12345'),
                'role' => 'admin',
                'is_active' => true,
            ]
        );
    }
}
