<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $driver = Schema::getConnection()->getDriverName();

        if ($driver !== 'sqlite') {
            return;
        }

        Schema::create('admin_users_new', function (Blueprint $table) {
            $table->id();
            $table->string('username')->unique();
            $table->string('name')->nullable();
            $table->string('email')->unique();
            $table->string('password');
            $table->string('role', 32)->default('admin');
            $table->json('permissions')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamp('last_login_at')->nullable();
            $table->rememberToken();
            $table->timestamps();
            $table->index('role');
        });

        DB::statement('INSERT INTO admin_users_new (id, username, name, email, password, role, permissions, is_active, last_login_at, remember_token, created_at, updated_at) SELECT id, username, name, email, password, role, permissions, is_active, last_login_at, remember_token, created_at, updated_at FROM admin_users');

        Schema::drop('admin_users');
        Schema::rename('admin_users_new', 'admin_users');
    }

    public function down(): void
    {
        $driver = Schema::getConnection()->getDriverName();

        if ($driver !== 'sqlite') {
            return;
        }

        Schema::create('admin_users_old', function (Blueprint $table) {
            $table->id();
            $table->string('username')->unique();
            $table->string('name')->nullable();
            $table->string('email')->unique();
            $table->string('password');
            $table->enum('role', ['super_admin', 'admin'])->default('admin');
            $table->json('permissions')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamp('last_login_at')->nullable();
            $table->rememberToken();
            $table->timestamps();
            $table->index('role');
        });

        DB::statement("INSERT INTO admin_users_old (id, username, name, email, password, role, permissions, is_active, last_login_at, remember_token, created_at, updated_at) SELECT id, username, name, email, password, CASE WHEN role = 'service_admin' THEN 'admin' ELSE role END, permissions, is_active, last_login_at, remember_token, created_at, updated_at FROM admin_users");

        Schema::drop('admin_users');
        Schema::rename('admin_users_old', 'admin_users');
    }
};
