<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $now = now();
        $posts = [
            [
                'demo_author_id' => '312459',
                'content' => "📢 Platform update\n\nWe’ve improved server stability and response times. Your trading bots will run more smoothly.\n\nThank you for being with us. 🚀",
                'image_path' => null,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'demo_author_id' => '465004',
                'content' => "🎯 New feature: Weight score\n\nUse your weight score to unlock higher limits and better options. Complete the steps in your profile to level up.\n\nQuestions? Check Help Center or contact support. 💡",
                'image_path' => null,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'demo_author_id' => '159277',
                'content' => "⚠️ Scheduled maintenance\n\nBrief maintenance is planned for next week. We’ll notify you 24 hours in advance. Your positions and data are safe.\n\nWe’ll keep it short. ✨",
                'image_path' => null,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'demo_author_id' => '249924',
                'content' => "🌐 AI Quantification – how it works\n\nOur system analyses market data and runs strategies within the rules you set. You choose profit target, max loss and pairs. The bot does the rest.\n\nStart small, learn, then scale. 📈",
                'image_path' => null,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'demo_author_id' => '523891',
                'content' => "❤️ Thank you\n\nYour feedback helps us improve. Keep sharing your experience and tips in Discover.\n\nWishing you steady growth and a calm mind. 🍀",
                'image_path' => null,
                'created_at' => $now,
                'updated_at' => $now,
            ],
        ];

        foreach ($posts as $post) {
            if (DB::table('announcements')->where('demo_author_id', $post['demo_author_id'])->doesntExist()) {
                DB::table('announcements')->insert($post);
            }
        }
    }

    public function down(): void
    {
        DB::table('announcements')->whereIn('demo_author_id', ['312459', '465004', '159277', '249924', '523891'])->delete();
    }
};
