<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('announcements', function (Blueprint $table) {
            $table->id();
            $table->string('demo_author_id', 32)->comment('Admin discover post ID style: 100000-599999');
            $table->text('content');
            $table->string('image_path')->nullable();
            $table->timestamps();
        });
        Schema::table('announcements', function (Blueprint $table) {
            $table->index(['created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('announcements');
    }
};
