<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $now = now();
        $posts = [
            [
                'user_id' => null,
                'demo_author_id' => 'D-001',
                'content' => "📈 BTC/USDT Analysis\n\n*Market Snapshot:*\n• Current momentum looks strong!\n• Great time to explore AI Quantification – let the bot handle the strategy. 🚀\n• Risk can be managed down to 0% with the right settings.\n\nEarn up to 100% or 1–8.5% profits. Try it! 💪",
                'image_path' => null,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'user_id' => null,
                'demo_author_id' => 'D-002',
                'content' => "🔥 Just closed my first bot with profit!\n\nThis AI trading bot is a real opportunity. I didn’t have to watch charts 24/7 – the system did the work.\n\nIf you’re new: start with a small amount, learn the steps, then scale. You’ve got this! 🌟",
                'image_path' => null,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'user_id' => null,
                'demo_author_id' => 'D-003',
                'content' => "💡 Tip for everyone:\n\n• Use the weight score to unlock better features.\n• Set your max profit % and max loss % so the bot fits your risk.\n• Check Discover and tips – lots of useful info here! 📚\n\nHappy trading! 🎯",
                'image_path' => null,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'user_id' => null,
                'demo_author_id' => 'D-004',
                'content' => "🌐 Market update:\n\nVolatility = opportunity. The AI model is built for this. Don’t panic on red days – the bot follows the rules you set.\n\nDiversify with different pairs and timeframes. Stay calm and let the system work! ✨",
                'image_path' => null,
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'user_id' => null,
                'demo_author_id' => 'D-005',
                'content' => "👋 New here? Welcome!\n\nThis platform is for everyone who wants to improve their financial future. 100% or 1–8.5% profit potential, with risk reduced to 0%.\n\nRead the training steps, try the bot, and ask in support if you need help. We’re all learning! 🚀❤️",
                'image_path' => null,
                'created_at' => $now,
                'updated_at' => $now,
            ],
        ];

        foreach ($posts as $post) {
            if (DB::table('discover_posts')->where('demo_author_id', $post['demo_author_id'])->doesntExist()) {
                DB::table('discover_posts')->insert($post);
            }
        }

        DB::table('system_settings')->updateOrInsert(
            ['key' => 'discover_demo_author_next'],
            [
                'value' => '6',
                'description' => 'Next demo author number for Discover (after seed D-001 to D-005)',
                'created_at' => $now,
                'updated_at' => $now,
            ]
        );
    }

    public function down(): void
    {
        DB::table('discover_posts')->whereIn('demo_author_id', ['D-001', 'D-002', 'D-003', 'D-004', 'D-005'])->delete();
        DB::table('system_settings')->where('key', 'discover_demo_author_next')->delete();
    }
};
