<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('discover_post_comments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('discover_post_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->string('author_display', 32)->nullable()->comment('e.g. D-002 for admin comment');
            $table->text('body');
            $table->timestamps();
        });
        Schema::table('discover_post_comments', function (Blueprint $table) {
            $table->index(['discover_post_id', 'created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('discover_post_comments');
    }
};
