<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('discover_post_likes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('discover_post_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->timestamps();
        });
        Schema::table('discover_post_likes', function (Blueprint $table) {
            $table->unique(['discover_post_id', 'user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('discover_post_likes');
    }
};
