<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('discover_posts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->string('demo_author_id', 32)->nullable()->comment('e.g. D-001 for admin demo posts');
            $table->text('content');
            $table->string('image_path')->nullable();
            $table->timestamps();
        });
        Schema::table('discover_posts', function (Blueprint $table) {
            $table->index(['created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('discover_posts');
    }
};
