<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $templates = [
            ['notification_welcome_title', 'Welcome to AI Quantification Trading', 'Title for welcome notification'],
            ['notification_welcome_message', 'This AI trading bot is a future opportunity for every user. Earn up to 100% or 1–8.5% profits with risk reduced to 0%. Explore multiple features and grow with us.', 'Welcome auto message body'],
            ['notification_deposit_approved_title', 'Deposit Approved', 'Title when admin approves deposit'],
            ['notification_deposit_approved_message', 'Your deposit has been approved. Use this AI trading bot to improve your financial income and grow your assets with smart automation.', 'Deposit approved message body'],
            ['notification_withdraw_approved_title', 'Withdrawal Completed', 'Title when admin completes withdrawal'],
            ['notification_withdraw_approved_message', 'Your withdrawal has been completed successfully. Funds have been sent to your requested address.', 'Withdrawal completed message body'],
        ];
        foreach ($templates as $t) {
            if (DB::table('system_settings')->where('key', $t[0])->doesntExist()) {
                DB::table('system_settings')->insert([
                    'key' => $t[0],
                    'value' => $t[1],
                    'description' => $t[2],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }

    public function down(): void
    {
        DB::table('system_settings')->whereIn('key', [
            'notification_welcome_title', 'notification_welcome_message',
            'notification_deposit_approved_title', 'notification_deposit_approved_message',
            'notification_withdraw_approved_title', 'notification_withdraw_approved_message',
        ])->delete();
    }
};
