<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->string('type', 64); // welcome, deposit_approved, withdraw_approved, bot_profit, admin_maintenance, admin_success, admin_info, admin_custom
            $table->string('title');
            $table->text('message');
            $table->json('data')->nullable(); // optional payload e.g. deposit_id, amount
            $table->timestamp('read_at')->nullable();
            $table->timestamps();
        });
        Schema::table('notifications', function (Blueprint $table) {
            $table->index(['user_id', 'read_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
