<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('ai_trade_bots', function (Blueprint $table) {
            // Admin-set trading time in minutes
            $table->integer('admin_set_trading_time_minutes')->nullable()->after('close_reason');
            
            // When admin activates/starts the bot (for calculating elapsed time)
            $table->timestamp('admin_activated_at')->nullable()->after('admin_set_trading_time_minutes');
            
            // Time-based profit/loss rules (JSON)
            // Structure: [
            //   { "start_minutes": 0, "end_minutes": 5, "type": "loss", "percent": 0.5 },
            //   { "start_minutes": 6, "end_minutes": 30, "type": "profit", "percent": 1.2 },
            //   { "after_complete": true, "type": "profit", "percent": 2.5 }
            // ]
            $table->json('time_based_profit_loss_rules')->nullable()->after('admin_activated_at');
        });
    }

    public function down(): void
    {
        Schema::table('ai_trade_bots', function (Blueprint $table) {
            $table->dropColumn([
                'admin_set_trading_time_minutes',
                'admin_activated_at',
                'time_based_profit_loss_rules'
            ]);
        });
    }
};

